/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.transport;

import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import com.floragunn.searchguard.ssl.transport.SearchGuardMessageChannelHandler;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.netty.NettyTransport;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.ssl.NotSslRecordException;
import org.jboss.netty.handler.ssl.SslHandler;

public class SearchGuardSSLNettyTransport
extends NettyTransport {
    private final SearchGuardKeyStore sgks;

    protected void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (this.lifecycle.started()) {
            Throwable cause = e.getCause();
            if (cause instanceof NotSslRecordException) {
                this.logger.warn("Someone speaks plaintext instead of ssl, will close the channel", new Object[0]);
                ctx.getChannel().close();
                this.disconnectFromNodeChannel(ctx.getChannel(), e.getCause());
                return;
            }
            if (cause instanceof SSLException) {
                this.logger.error("SSL Problem " + cause.getMessage(), cause, new Object[0]);
                ctx.getChannel().close();
                this.disconnectFromNodeChannel(ctx.getChannel(), e.getCause());
                return;
            }
            if (cause instanceof SSLHandshakeException) {
                this.logger.error("Problem during handshake " + cause.getMessage(), new Object[0]);
                ctx.getChannel().close();
                this.disconnectFromNodeChannel(ctx.getChannel(), e.getCause());
                return;
            }
        }
        super.exceptionCaught(ctx, e);
    }

    @Inject
    public SearchGuardSSLNettyTransport(Settings settings, ThreadPool threadPool, NetworkService networkService, BigArrays bigArrays, Version version, NamedWriteableRegistry namedWriteableRegistry, SearchGuardKeyStore sgks) {
        super(settings, threadPool, networkService, bigArrays, version, namedWriteableRegistry);
        this.sgks = sgks;
    }

    public ChannelPipelineFactory configureClientChannelPipelineFactory() {
        this.logger.debug("Node client configured for SSL", new Object[0]);
        return new SSLClientChannelPipelineFactory(this, this.settings, this.logger, this.sgks);
    }

    public ChannelPipelineFactory configureServerChannelPipelineFactory(String name, Settings settings) {
        this.logger.debug("Node server configured for SSL", new Object[0]);
        return new SSLServerChannelPipelineFactory(this, name, settings, this.settings, this.logger, this.sgks);
    }

    protected static class SSLClientChannelPipelineFactory
    extends NettyTransport.ClientChannelPipelineFactory {
        private final boolean hostnameVerificationEnabled;
        private final boolean hostnameVerificationResovleHostName;
        private final ESLogger nettyLogger;
        private final SearchGuardKeyStore sgks;

        public SSLClientChannelPipelineFactory(NettyTransport nettyTransport, Settings settings, ESLogger nettyLogger, SearchGuardKeyStore sgks) {
            super(nettyTransport);
            this.sgks = sgks;
            this.hostnameVerificationEnabled = settings.getAsBoolean("searchguard.ssl.transport.enforce_hostname_verification", Boolean.valueOf(true));
            this.hostnameVerificationResovleHostName = settings.getAsBoolean("searchguard.ssl.transport.resolve_hostname", Boolean.valueOf(true));
            this.nettyLogger = nettyLogger;
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = super.getPipeline();
            pipeline.addFirst("client_ssl_handler", (ChannelHandler)new ClientSSLHandler(this.sgks, this.hostnameVerificationEnabled, this.hostnameVerificationResovleHostName));
            pipeline.replace("dispatcher", "dispatcher", (ChannelHandler)new SearchGuardMessageChannelHandler(this.nettyTransport, this.nettyLogger));
            return pipeline;
        }
    }

    protected static class ClientSSLHandler
    extends SimpleChannelHandler {
        private final ESLogger log = Loggers.getLogger(((Object)((Object)this)).getClass());
        private final boolean hostnameVerificationEnabled;
        private final boolean hostnameVerificationResovleHostName;
        private final SearchGuardKeyStore sgks;

        private ClientSSLHandler(SearchGuardKeyStore sgks, boolean hostnameVerificationEnabled, boolean hostnameVerificationResovleHostName) {
            this.sgks = sgks;
            this.hostnameVerificationEnabled = hostnameVerificationEnabled;
            this.hostnameVerificationResovleHostName = hostnameVerificationResovleHostName;
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            super.exceptionCaught(ctx, e);
        }

        public void connectRequested(ChannelHandlerContext ctx, ChannelStateEvent event) {
            SSLEngine engine = null;
            try {
                if (this.hostnameVerificationEnabled) {
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)event.getValue();
                    String hostname = null;
                    hostname = this.hostnameVerificationResovleHostName ? inetSocketAddress.getHostName() : inetSocketAddress.getHostString();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Hostname of peer is {} with hostnameVerificationResovleHostName: {}", new Object[]{hostname, this.hostnameVerificationResovleHostName});
                    }
                    engine = this.sgks.createClientTransportSSLEngine(hostname, inetSocketAddress.getPort());
                } else {
                    engine = this.sgks.createClientTransportSSLEngine(null, -1);
                }
            }
            catch (SSLException e) {
                throw ExceptionsHelper.convertToElastic((Throwable)e);
            }
            SslHandler sslHandler = new SslHandler(engine);
            sslHandler.setEnableRenegotiation(false);
            ctx.getPipeline().replace((ChannelHandler)this, "ssl_client", (ChannelHandler)sslHandler);
            ctx.sendDownstream((ChannelEvent)event);
        }
    }

    protected static class SSLServerChannelPipelineFactory
    extends NettyTransport.ServerChannelPipelineFactory {
        private final ESLogger nettyLogger;
        private final SearchGuardKeyStore sgks;

        public SSLServerChannelPipelineFactory(NettyTransport nettyTransport, String name, Settings sslsettings, Settings essettings, ESLogger nettyLogger, SearchGuardKeyStore sgks) {
            super(nettyTransport, name, sslsettings);
            this.sgks = sgks;
            this.nettyLogger = nettyLogger;
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = super.getPipeline();
            SslHandler sslHandler = new SslHandler(this.sgks.createServerTransportSSLEngine());
            sslHandler.setEnableRenegotiation(false);
            pipeline.addFirst("ssl_server", (ChannelHandler)sslHandler);
            pipeline.replace("dispatcher", "dispatcher", (ChannelHandler)new SearchGuardMessageChannelHandler(this.nettyTransport, this.nettyLogger));
            return pipeline;
        }
    }
}

