/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.transport;

import java.io.IOException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.netty.MessageChannelHandler;
import org.elasticsearch.transport.netty.NettyTransport;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.ssl.NotSslRecordException;
import org.jboss.netty.handler.ssl.SslHandler;

public class SearchGuardMessageChannelHandler
extends MessageChannelHandler {
    public SearchGuardMessageChannelHandler(NettyTransport transport, ESLogger logger) {
        super(transport, logger, "");
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
    }

    protected void handleResponse(Channel channel, StreamInput buffer, TransportResponseHandler handler) {
        super.handleResponse(channel, buffer, handler);
    }

    protected String handleRequest(Channel channel, StreamInput buffer, long requestId, Version version) throws IOException {
        String action = super.handleRequest(channel, buffer, requestId, version);
        return action;
    }

    public void channelConnected(final ChannelHandlerContext ctx, final ChannelStateEvent e) {
        final SslHandler sslHandler = (SslHandler)ctx.getPipeline().get(SslHandler.class);
        if (sslHandler == null) {
            return;
        }
        ChannelFuture handshakeFuture = sslHandler.handshake();
        handshakeFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (SearchGuardMessageChannelHandler.this.logger.isTraceEnabled()) {
                    SearchGuardMessageChannelHandler.this.logger.trace("Node to Node encryption cipher is {}/{}", new Object[]{sslHandler.getEngine().getSession().getProtocol(), sslHandler.getEngine().getSession().getCipherSuite()});
                }
                ctx.sendUpstream((ChannelEvent)e);
            }
        });
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Throwable cause = e.getCause();
        if (cause instanceof NotSslRecordException) {
            this.logger.warn("Someone speaks plaintext instead of ssl, will close the channel", new Object[0]);
            ctx.getChannel().close();
            return;
        }
        if (cause instanceof SSLException) {
            this.logger.error("SSL Problem " + cause.getMessage(), cause, new Object[0]);
            ctx.getChannel().close();
            return;
        }
        if (cause instanceof SSLHandshakeException) {
            this.logger.error("Problem during handshake " + cause.getMessage(), new Object[0]);
            ctx.getChannel().close();
            return;
        }
        super.exceptionCaught(ctx, e);
    }
}

