/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.http.netty;

import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.auth.x500.X500Principal;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.netty.NettyHttpRequest;
import org.elasticsearch.http.netty.NettyHttpServerTransport;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.handler.ssl.NotSslRecordException;
import org.jboss.netty.handler.ssl.SslHandler;

public class SearchGuardSSLNettyHttpServerTransport
extends NettyHttpServerTransport {
    private final SearchGuardKeyStore sgks;

    @Inject
    public SearchGuardSSLNettyHttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, SearchGuardKeyStore sgks) {
        super(settings, networkService, bigArrays);
        this.sgks = sgks;
    }

    public ChannelPipelineFactory configureServerChannelPipelineFactory() {
        return new SSLHttpChannelPipelineFactory(this, this.settings, this.detailedErrorsEnabled, this.sgks);
    }

    protected void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (this.lifecycle.started()) {
            Throwable cause = e.getCause();
            if (cause instanceof NotSslRecordException) {
                this.logger.warn("Someone speaks plaintext instead of ssl, will close the channel", new Object[0]);
                ctx.getChannel().close();
                return;
            }
            if (cause instanceof SSLException) {
                this.logger.error("SSL Problem " + cause.getMessage(), cause, new Object[0]);
                ctx.getChannel().close();
                return;
            }
            if (cause instanceof SSLHandshakeException) {
                this.logger.error("Problem during handshake " + cause.getMessage(), new Object[0]);
                ctx.getChannel().close();
                return;
            }
        }
        super.exceptionCaught(ctx, e);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dispatchRequest(HttpRequest request, HttpChannel channel) {
        SslHandler sslhandler;
        block8: {
            NettyHttpRequest nettyHttpRequest = (NettyHttpRequest)request;
            sslhandler = (SslHandler)nettyHttpRequest.getChannel().getPipeline().get("ssl_http");
            SSLEngine engine = sslhandler.getEngine();
            if (engine.getNeedClientAuth() || engine.getWantClientAuth()) {
                try {
                    Certificate[] certs = sslhandler.getEngine().getSession().getPeerCertificates();
                    if (certs != null && certs.length > 0 && certs[0] instanceof X509Certificate) {
                        X509Certificate[] x509Certs = (X509Certificate[])Arrays.copyOf(certs, certs.length, X509Certificate[].class);
                        X500Principal principal = x509Certs[0].getSubjectX500Principal();
                        request.putInContext((Object)"_sg_ssl_principal", (Object)(principal == null ? null : principal.getName()));
                        request.putInContext((Object)"_sg_ssl_peer_certificates", (Object)x509Certs);
                        break block8;
                    } else if (engine.getNeedClientAuth()) {
                        ElasticsearchException ex = new ElasticsearchException("No client certificates found but such are needed (SG 9).", new Object[0]);
                        this.errorThrown((Throwable)ex, nettyHttpRequest);
                        throw ex;
                    }
                    break block8;
                }
                catch (SSLPeerUnverifiedException e) {
                    if (engine.getNeedClientAuth()) {
                        this.logger.error("No client certificates found but such are needed (SG 8).", new Object[0]);
                        this.errorThrown(e, nettyHttpRequest);
                        throw ExceptionsHelper.convertToElastic((Throwable)e);
                    }
                    break block8;
                }
                catch (Exception e) {
                    this.logger.error("Unknow error (SG 8) : " + e, (Throwable)e, new Object[0]);
                    this.errorThrown(e, nettyHttpRequest);
                    throw ExceptionsHelper.convertToElastic((Throwable)e);
                }
            }
            request.putInContext((Object)"_sg_ssl_client_auth_none", (Object)true);
        }
        request.putInContext((Object)"_sg_ssl_protocol", (Object)sslhandler.getEngine().getSession().getProtocol());
        request.putInContext((Object)"_sg_ssl_cipher", (Object)sslhandler.getEngine().getSession().getCipherSuite());
        super.dispatchRequest(request, channel);
    }

    protected void errorThrown(Throwable t, NettyHttpRequest request) {
    }

    protected static class SSLHttpChannelPipelineFactory
    extends NettyHttpServerTransport.HttpChannelPipelineFactory {
        protected final ESLogger log = Loggers.getLogger(((Object)((Object)this)).getClass());
        private final SearchGuardKeyStore sgks;

        public SSLHttpChannelPipelineFactory(NettyHttpServerTransport transport, Settings settings, boolean detailedErrorsEnabled, SearchGuardKeyStore sgks) {
            super(transport, detailedErrorsEnabled);
            this.sgks = sgks;
        }

        public ChannelPipeline getPipeline() throws Exception {
            this.log.trace("SslHandler configured and added to netty pipeline", new Object[0]);
            ChannelPipeline pipeline = super.getPipeline();
            SslHandler sslHandler = new SslHandler(this.sgks.createHTTPSSLEngine());
            sslHandler.setEnableRenegotiation(false);
            pipeline.addFirst("ssl_http", (ChannelHandler)sslHandler);
            return pipeline;
        }
    }
}

