/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl;

import com.floragunn.searchguard.ssl.SearchGuardSSLModule;
import com.floragunn.searchguard.ssl.http.netty.SearchGuardSSLNettyHttpServerTransport;
import com.floragunn.searchguard.ssl.rest.SearchGuardSSLInfoAction;
import com.floragunn.searchguard.ssl.transport.SearchGuardSSLNettyTransport;
import com.floragunn.searchguard.ssl.transport.SearchGuardSSLTransportService;
import com.google.common.collect.ImmutableList;
import io.netty.handler.ssl.OpenSsl;
import io.netty.util.internal.PlatformDependent;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Collection;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.EnvironmentModule;
import org.elasticsearch.http.HttpServerModule;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestModule;
import org.elasticsearch.transport.TransportModule;

public final class SearchGuardSSLPlugin
extends Plugin {
    private final ESLogger log = Loggers.getLogger(((Object)((Object)this)).getClass());
    static final String CLIENT_TYPE = "client.type";
    private final boolean client;
    private final boolean httpSSLEnabled;
    private final boolean transportSSLEnabled;
    private boolean searchGuardPluginAvailable;
    private final Settings settings;

    public SearchGuardSSLPlugin(Settings settings) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                PlatformDependent.hasUnsafe();
                OpenSsl.isAvailable();
                return null;
            }
        });
        try {
            ((Object)((Object)this)).getClass().getClassLoader().loadClass("com.floragunn.searchguard.SearchGuardPlugin");
            this.searchGuardPluginAvailable = settings.getAsArray("searchguard.authcz.admin_dn", new String[0]).length > 0;
        }
        catch (ClassNotFoundException cnfe) {
            this.searchGuardPluginAvailable = false;
        }
        if (this.searchGuardPluginAvailable) {
            this.log.info("Search Guard 2 plugin also available", new Object[0]);
        } else {
            this.log.info("Search Guard 2 plugin not available", new Object[0]);
        }
        this.settings = settings;
        this.client = !"node".equals(this.settings.get(CLIENT_TYPE));
        this.httpSSLEnabled = settings.getAsBoolean("searchguard.ssl.http.enabled", Boolean.valueOf(false));
        this.transportSSLEnabled = settings.getAsBoolean("searchguard.ssl.transport.enabled", Boolean.valueOf(true));
        if (!this.httpSSLEnabled && !this.transportSSLEnabled) {
            this.log.error("SSL not activated for http and/or transport.", new Object[0]);
            System.out.println("SSL not activated for http and/or transport.");
        }
    }

    public void onModule(RestModule module) {
        if (!this.client) {
            module.addRestAction(SearchGuardSSLInfoAction.class);
        }
    }

    public void onModule(HttpServerModule module) {
        if (!this.client && this.httpSSLEnabled && !this.searchGuardPluginAvailable) {
            module.setHttpServerTransport(SearchGuardSSLNettyHttpServerTransport.class, this.name());
        }
    }

    public void onModule(TransportModule module) {
        if (this.transportSSLEnabled) {
            module.setTransport(SearchGuardSSLNettyTransport.class, this.name());
            if (!this.client && !this.searchGuardPluginAvailable) {
                module.setTransportService(SearchGuardSSLTransportService.class, this.name());
            }
        }
    }

    public Collection<Module> nodeModules() {
        if (!this.client) {
            return ImmutableList.of((Object)((Object)new SearchGuardSSLModule(this.settings)));
        }
        return ImmutableList.of((Object)((Object)new SearchGuardSSLModule(this.settings)), (Object)new EnvironmentModule(new Environment(this.settings)));
    }

    public String description() {
        return "Search Guard SSL";
    }

    public String name() {
        return "search-guard-ssl";
    }
}

