/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.tools;

import com.floragunn.searchguard.SearchGuardPlugin;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.ssl.SearchGuardSSLPlugin;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class SearchGuardAdmin {
    public static void main(String[] args) {
        try {
            SearchGuardAdmin.main0(args);
        }
        catch (NoNodeAvailableException e) {
            System.out.println("ERR: Cannot connect to elasticsearch. Please refer to elasticsearch logfile for more information");
            System.out.println("Trace:");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (Exception e) {
            System.out.println("ERR: An unexpected " + e.getClass().getSimpleName() + " occured: " + e.getMessage());
            System.out.println("Trace:");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void main0(String[] args) throws Exception {
        String ts;
        String ks;
        String kspass;
        System.setProperty("sg.nowarn.client", "true");
        HelpFormatter formatter = new HelpFormatter();
        Options options = new Options();
        options.addOption("nhnv", "disable-host-name-verification", false, "Disable hostname verification");
        options.addOption("nrhn", "disable-resolve-hostname", false, "Disable hostname beeing resolved");
        options.addOption(Option.builder((String)"ts").longOpt("truststore").hasArg().argName("file").required().desc("Path to truststore (JKS/PKCS12 format)").build());
        options.addOption(Option.builder((String)"ks").longOpt("keystore").hasArg().argName("file").required().desc("Path to keystore (JKS/PKCS12 format").build());
        options.addOption(Option.builder((String)"tst").longOpt("truststore-type").hasArg().argName("type").desc("JKS or PKCS12, if not given use file ext. to dectect type").build());
        options.addOption(Option.builder((String)"kst").longOpt("keystore-type").hasArg().argName("type").desc("JKS or PKCS12, if not given use file ext. to dectect type").build());
        options.addOption(Option.builder((String)"tspass").longOpt("truststore-password").hasArg().argName("password").desc("Truststore password").build());
        options.addOption(Option.builder((String)"kspass").longOpt("keystore-password").hasArg().argName("password").desc("Keystore password").build());
        options.addOption(Option.builder((String)"cd").longOpt("configdir").hasArg().argName("directory").desc("Directory for config files").build());
        options.addOption(Option.builder((String)"h").longOpt("hostname").hasArg().argName("host").desc("Elasticsearch host").build());
        options.addOption(Option.builder((String)"p").longOpt("port").hasArg().argName("port").desc("Elasticsearch transport port (normally 9300)").build());
        options.addOption(Option.builder((String)"cn").longOpt("clustername").hasArg().argName("clustername").desc("Clustername").build());
        options.addOption("sniff", "enable-sniffing", false, "Enable client.transport.sniff");
        options.addOption("icl", "ignore-clustername", false, "Ignore clustername");
        options.addOption(Option.builder((String)"r").longOpt("retrieve").desc("retrieve current config").build());
        options.addOption(Option.builder((String)"f").longOpt("file").hasArg().argName("file").desc("file").build());
        options.addOption(Option.builder((String)"t").longOpt("type").hasArg().argName("file-type").desc("file-type").build());
        options.addOption(Option.builder((String)"tsalias").longOpt("truststore-alias").hasArg().argName("alias").desc("Truststore alias").build());
        options.addOption(Option.builder((String)"ksalias").longOpt("keystore-alias").hasArg().argName("alias").desc("Keystore alias").build());
        options.addOption(Option.builder((String)"ec").longOpt("enabled-ciphers").hasArg().argName("cipers").desc("Comma separated list of TLS ciphers").build());
        options.addOption(Option.builder((String)"ep").longOpt("enabled-protocols").hasArg().argName("protocols").desc("Comma separated list of TLS protocols").build());
        options.addOption(Option.builder((String)"us").longOpt("update_settings").hasArg().argName("number of replicas").desc("update settings").build());
        String hostname = "localhost";
        int port = 9300;
        String tspass = kspass = "changeit";
        String cd = ".";
        String kst = null;
        String tst = null;
        boolean nhnv = false;
        boolean nrhn = false;
        boolean sniff = false;
        boolean icl = false;
        String clustername = "elasticsearch";
        String file = null;
        String type = null;
        boolean retrieve = false;
        String ksAlias = null;
        String tsAlias = null;
        String[] enabledProtocols = new String[]{};
        String[] enabledCiphers = new String[]{};
        Integer updateSettings = null;
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine line = parser.parse(options, args);
            hostname = line.getOptionValue("h", hostname);
            port = Integer.parseInt(line.getOptionValue("p", String.valueOf(port)));
            kspass = line.getOptionValue("kspass", kspass);
            tspass = line.getOptionValue("tspass", tspass);
            cd = line.getOptionValue("cd", cd);
            if (!cd.endsWith(File.separator)) {
                cd = cd + File.separator;
            }
            ks = line.getOptionValue("ks");
            ts = line.getOptionValue("ts");
            kst = line.getOptionValue("kst", kst);
            tst = line.getOptionValue("tst", tst);
            nhnv = line.hasOption("nhnv");
            nrhn = line.hasOption("nrhn");
            clustername = line.getOptionValue("cn", clustername);
            sniff = line.hasOption("sniff");
            icl = line.hasOption("icl");
            file = line.getOptionValue("f", file);
            type = line.getOptionValue("t", type);
            retrieve = line.hasOption("r");
            ksAlias = line.getOptionValue("ksalias", ksAlias);
            tsAlias = line.getOptionValue("tsalias", tsAlias);
            String enabledCiphersString = line.getOptionValue("ec", null);
            String enabledProtocolsString = line.getOptionValue("ep", null);
            if (enabledCiphersString != null) {
                enabledCiphers = enabledCiphersString.split(",");
            }
            if (enabledProtocolsString != null) {
                enabledProtocols = enabledProtocolsString.split(",");
            }
            updateSettings = line.hasOption("us") ? Integer.valueOf(Integer.parseInt(line.getOptionValue("us"))) : null;
        }
        catch (ParseException exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
            formatter.printHelp("sgadmin.sh", options, true);
            return;
        }
        if (port == 9200) {
            System.out.println("WARNING: Seems you want connect to the default HTTP port 9200." + System.lineSeparator() + "         sgadmin connect through the transport port which is normally 9300.");
        }
        System.out.println("Connect to " + hostname + ":" + port);
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(hostname, port));
        }
        catch (ConnectException ex) {
            System.out.println("Seems there is no elasticsearch running on " + hostname + ":" + port + " - Will exit");
            System.exit(-1);
        }
        finally {
            try {
                socket.close();
            }
            catch (Exception ex) {}
        }
        Settings.Builder settingsBuilder = Settings.builder().put("path.home", ".").put("path.conf", ".").put("searchguard.ssl.transport.keystore_filepath", ks).put("searchguard.ssl.transport.truststore_filepath", ts).put("searchguard.ssl.transport.keystore_password", kspass).put("searchguard.ssl.transport.truststore_password", tspass).put("searchguard.ssl.transport.enforce_hostname_verification", !nhnv).put("searchguard.ssl.transport.resolve_hostname", !nrhn).put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.keystore_type", kst == null ? (ks.endsWith(".jks") ? "JKS" : "PKCS12") : kst).put("searchguard.ssl.transport.truststore_type", tst == null ? (ts.endsWith(".jks") ? "JKS" : "PKCS12") : tst).putArray("searchguard.ssl.transport.enabled_ciphers", enabledCiphers).putArray("searchguard.ssl.transport.enabled_protocols", enabledProtocols).put("cluster.name", clustername).put("client.transport.ignore_cluster_name", icl).put("client.transport.sniff", sniff);
        if (ksAlias != null) {
            settingsBuilder.put("searchguard.ssl.transport.keystore_alias", ksAlias);
        }
        if (tsAlias != null) {
            settingsBuilder.put("searchguard.ssl.transport.truststore_alias", tsAlias);
        }
        Settings settings = settingsBuilder.build();
        try (TransportClient tc = TransportClient.builder().settings(settings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build().addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(hostname, port)));){
            ConfigUpdateResponse cur;
            boolean success;
            boolean indexExists;
            ClusterHealthResponse chr;
            boolean timedOut;
            if (updateSettings != null) {
                Settings indexSettings = Settings.builder().put("index.number_of_replicas", updateSettings.intValue()).build();
                tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
                UpdateSettingsResponse response = (UpdateSettingsResponse)tc.admin().indices().updateSettings(new UpdateSettingsRequest(new String[]{"searchguard"}).settings(indexSettings)).actionGet();
                System.out.println("Reload config on all nodes");
                System.out.println("Update number of replicas to " + updateSettings + " with result: " + response.isAcknowledged());
                System.exit(response.isAcknowledged() ? 0 : -1);
            }
            if (timedOut = (chr = (ClusterHealthResponse)tc.admin().cluster().health(new ClusterHealthRequest().waitForYellowStatus()).actionGet()).isTimedOut()) {
                System.out.println("Cluster state timeout");
                System.exit(-1);
            }
            if (!(indexExists = ((IndicesExistsResponse)tc.admin().indices().exists(new IndicesExistsRequest(new String[]{"searchguard"})).actionGet()).isExists())) {
                System.out.print("searchguard index does not exists, attempt to create it ... ");
                boolean indexCreated = ((CreateIndexResponse)tc.admin().indices().create(new CreateIndexRequest("searchguard").settings(new Object[]{"index.number_of_shards", 1, "index.number_of_replicas", chr.getNumberOfDataNodes() - 1})).actionGet()).isAcknowledged();
                if (!indexCreated) {
                    System.out.println("failed");
                    return;
                }
                System.out.println("done");
            } else {
                System.out.println("Index does already exists");
            }
            if (retrieve) {
                String date = new SimpleDateFormat("yyyy-MMM-dd_HH-mm-ss", Locale.ENGLISH).format(new Date());
                success = SearchGuardAdmin.retrieveFile((Client)tc, cd + "sg_config_" + date + ".yml", "config");
                success &= SearchGuardAdmin.retrieveFile((Client)tc, cd + "sg_roles_" + date + ".yml", "roles");
                success &= SearchGuardAdmin.retrieveFile((Client)tc, cd + "sg_roles_mapping_" + date + ".yml", "rolesmapping");
                success &= SearchGuardAdmin.retrieveFile((Client)tc, cd + "sg_internal_users_" + date + ".yml", "internalusers");
                System.exit((success &= SearchGuardAdmin.retrieveFile((Client)tc, cd + "sg_action_groups_" + date + ".yml", "actiongroups")) ? 0 : -1);
            }
            boolean isCdAbs = new File(cd).isAbsolute();
            System.out.println("Populate config from " + (isCdAbs ? cd : new File(".", cd).getCanonicalPath()));
            if (file != null) {
                if (type == null) {
                    System.out.println("type missing");
                    System.exit(-1);
                }
                if (!Arrays.asList("config", "roles", "rolesmapping", "internalusers", "actiongroups").contains(type)) {
                    System.out.println("Invalid type '" + type + "'");
                    System.exit(-1);
                }
                System.exit((success = SearchGuardAdmin.uploadFile((Client)tc, file, type)) ? 0 : -1);
            }
            success = SearchGuardAdmin.uploadFile((Client)tc, cd + "sg_config.yml", "config");
            success &= SearchGuardAdmin.uploadFile((Client)tc, cd + "sg_roles.yml", "roles");
            success &= SearchGuardAdmin.uploadFile((Client)tc, cd + "sg_roles_mapping.yml", "rolesmapping");
            success &= SearchGuardAdmin.uploadFile((Client)tc, cd + "sg_internal_users.yml", "internalusers");
            success &= SearchGuardAdmin.uploadFile((Client)tc, cd + "sg_action_groups.yml", "actiongroups");
            System.out.println("Done with " + ((success &= ((ConfigUpdateResponse.Node[])(cur = (ConfigUpdateResponse)((Object)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet())).getNodes()).length == chr.getNumberOfNodes()) ? "success" : "failures"));
            System.exit(success ? 0 : -1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean uploadFile(Client tc, String filepath, String type) {
        System.out.println("Will update '" + type + "' with " + filepath);
        try (FileReader reader = new FileReader(filepath);){
            String id = ((IndexResponse)tc.index(((IndexRequest)new IndexRequest("searchguard").type(type).id("0").refresh(true).consistencyLevel(WriteConsistencyLevel.DEFAULT)).source(SearchGuardAdmin.readXContent(reader, XContentType.YAML))).actionGet()).getId();
            if ("0".equals(id)) {
                System.out.println("   SUCC Configuration for '" + type + "' created or updated");
                boolean bl = true;
                return bl;
            }
            System.out.println("   FAIL Configuration for '" + type + "' failed for unknown reasons. Pls. consult logfile of elasticsearch");
            return false;
        }
        catch (IOException e) {
            System.out.println("   FAIL Configuration for '" + type + "' failed because of " + e.toString());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean retrieveFile(Client tc, String filepath, String type) {
        System.out.println("Will retrieve '" + type + "' into " + filepath);
        try (FileWriter writer = new FileWriter(filepath);){
            GetResponse response = (GetResponse)tc.get(new GetRequest("searchguard").type(type).id("0").refresh(true).realtime(Boolean.valueOf(false))).actionGet();
            if (response.isExists()) {
                if (response.isSourceEmpty()) {
                    System.out.println("   FAIL Configuration for '" + type + "' failed because of empty source");
                    boolean bl = false;
                    return bl;
                }
                String yaml = SearchGuardAdmin.convertToYaml(response.getSourceAsBytesRef(), true);
                writer.write(yaml);
                System.out.println("   SUCC Configuration for '" + type + "' stored in " + filepath);
                boolean bl = true;
                return bl;
            }
            System.out.println("   FAIL Get configuration for '" + type + "' because it does not exist");
            return false;
        }
        catch (IOException e) {
            System.out.println("   FAIL Get configuration for '" + type + "' failed because of " + e.toString());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BytesReference readXContent(Reader reader, XContentType xContentType) throws IOException {
        try (XContentParser parser = null;){
            parser = XContentFactory.xContent((XContentType)xContentType).createParser(reader);
            parser.nextToken();
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.copyCurrentStructure(parser);
            BytesReference bytesReference = builder.bytes();
            return bytesReference;
        }
    }

    private static String convertToYaml(BytesReference bytes, boolean prettyPrint) throws IOException {
        try (XContentParser parser = XContentFactory.xContent((XContentType)XContentFactory.xContentType((BytesReference)bytes)).createParser((InputStream)bytes.streamInput());){
            parser.nextToken();
            XContentBuilder builder = XContentFactory.yamlBuilder();
            if (prettyPrint) {
                builder.prettyPrint();
            }
            builder.copyCurrentStructure(parser);
            String string = builder.string();
            return string;
        }
    }
}

