/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.support;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class WildcardMatcher {
    public static boolean matchAny(String[] pattern, String[] candidate) {
        for (int i = 0; i < pattern.length; ++i) {
            String string = pattern[i];
            if (!WildcardMatcher.matchAny(string, candidate)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchAll(String[] pattern, String[] candidate) {
        for (int i = 0; i < candidate.length; ++i) {
            String string = candidate[i];
            if (WildcardMatcher.matchAny(pattern, string)) continue;
            return false;
        }
        return true;
    }

    public static boolean matchAny(String pattern, String[] candidate) {
        for (int i = 0; i < candidate.length; ++i) {
            String string = candidate[i];
            if (!WildcardMatcher.match(pattern, string)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getMatchAny(String pattern, String[] candidate) {
        ArrayList<String> matches = new ArrayList<String>(candidate.length);
        for (int i = 0; i < candidate.length; ++i) {
            String string = candidate[i];
            if (!WildcardMatcher.match(pattern, string)) continue;
            matches.add(string);
        }
        return matches;
    }

    public static boolean matchAny(String[] pattern, String candidate) {
        for (int i = 0; i < pattern.length; ++i) {
            String string = pattern[i];
            if (!WildcardMatcher.match(string, candidate)) continue;
            return true;
        }
        return false;
    }

    public static boolean match(String pattern, String candidate) {
        if (pattern == null || candidate == null) {
            return false;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/")) {
            return Pattern.matches("^" + pattern.substring(1, pattern.length() - 1) + "$", candidate);
        }
        if (!pattern.startsWith("/") && !pattern.endsWith("/")) {
            return Pattern.matches(pattern.replace(".", "\\.").replace("*", ".*").replace("?", "."), candidate);
        }
        return false;
    }

    public static boolean containsWildcard(String pattern) {
        return pattern != null && (pattern.contains("*") || pattern.contains("?") || pattern.startsWith("/") && pattern.endsWith("/"));
    }
}

