/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.EmptyReader;
import com.floragunn.searchguard.configuration.RequestHolder;
import com.floragunn.searchguard.support.HeaderHelper;
import com.floragunn.searchguard.user.User;
import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.IndexSearcherWrapper;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.transport.TransportRequest;

public class SearchGuardIndexSearcherWrapper
extends AbstractIndexShardComponent
implements IndexSearcherWrapper {
    private final AdminDNs admindns;
    protected final ESLogger log = Loggers.getLogger(((Object)((Object)this)).getClass());
    private volatile boolean shardReady;

    @Inject
    public SearchGuardIndexSearcherWrapper(final ShardId shardId, IndicesLifecycle indicesLifecycle, Settings indexSettings, AdminDNs admindns) {
        super(shardId, indexSettings);
        this.admindns = admindns;
        if (!this.isSearchGuardIndexRequest()) {
            indicesLifecycle.addListener(new IndicesLifecycle.Listener(){

                public void afterIndexShardPostRecovery(IndexShard indexShard) {
                    if (shardId.equals((Object)indexShard.shardId())) {
                        SearchGuardIndexSearcherWrapper.this.shardReady = true;
                    }
                }
            });
        } else {
            this.shardReady = true;
        }
    }

    public final DirectoryReader wrap(DirectoryReader reader) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("DirectoryReader {} should be wrapped", new Object[]{reader.getClass()});
        }
        if (!this.shardReady) {
            return reader;
        }
        if (!this.isAdminAuhtenticatedOrInternalRequest()) {
            return this.dlsFlsWrap(reader);
        }
        return reader;
    }

    public final IndexSearcher wrap(EngineConfig engineConfig, IndexSearcher searcher) throws EngineException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("IndexSearcher {} should be wrapped (reader is {})", new Object[]{searcher.getClass(), searcher.getIndexReader().getClass()});
        }
        if (!this.shardReady) {
            return searcher;
        }
        if (this.isSearchGuardIndexRequest() && !this.isAdminAuhtenticatedOrInternalRequest()) {
            return new IndexSearcher((IndexReader)new EmptyReader());
        }
        if (!this.isAdminAuhtenticatedOrInternalRequest()) {
            return this.dlsFlsWrap(engineConfig, searcher);
        }
        return searcher;
    }

    protected IndexSearcher dlsFlsWrap(EngineConfig engineConfig, IndexSearcher searcher) throws EngineException {
        return searcher;
    }

    protected DirectoryReader dlsFlsWrap(DirectoryReader reader) throws IOException {
        return reader;
    }

    protected final boolean isAdminAuhtenticatedOrInternalRequest() {
        TransportRequest request;
        RequestHolder current = RequestHolder.current();
        if (current != null && (request = current.getRequest()) != null) {
            User user = (User)request.getFromContext((Object)"_sg_user");
            if (user != null && this.admindns.isAdmin(user.getName())) {
                return true;
            }
            if ("true".equals(HeaderHelper.getSafeFromHeader(request, "_sg_conf_request"))) {
                return true;
            }
        }
        return false;
    }

    protected final boolean isSearchGuardIndexRequest() {
        return this.shardId.index().getName().equals("searchguard");
    }
}

