/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.searchguard.action.configupdate.TransportConfigUpdateAction;
import com.floragunn.searchguard.configuration.ConfigChangeListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class ActionGroupHolder
implements ConfigChangeListener {
    private volatile Settings actionGroups;

    @Inject
    public ActionGroupHolder(TransportConfigUpdateAction tcua) {
        tcua.addConfigChangeListener("actiongroups", this);
    }

    @Override
    public void onChange(String event, Settings settings) {
        this.actionGroups = settings;
    }

    @Override
    public void validate(String event, Settings settings) throws ElasticsearchSecurityException {
    }

    @Override
    public boolean isInitialized() {
        return this.actionGroups != null;
    }

    public Set<String> getGroupMembers(String groupname) {
        if (!this.isInitialized()) {
            return Collections.emptySet();
        }
        return this.resolve(groupname);
    }

    private Set<String> resolve(String entry) {
        HashSet<String> ret = new HashSet<String>();
        String[] en = this.actionGroups.getAsArray(entry);
        for (int i = 0; i < en.length; ++i) {
            String string = en[i];
            if (this.actionGroups.names().contains(string)) {
                ret.addAll(this.resolve(string));
                continue;
            }
            ret.add(string);
        }
        return ret;
    }
}

