/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.acl.SearchGuardRolesMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class RolesMappingBuilder {
    private Map<String, HashSet<String>> roles = new HashMap<String, HashSet<String>>();
    private List<SearchGuardRolesMapping.RolesMapping> rolesMappings = new ArrayList<SearchGuardRolesMapping.RolesMapping>();

    public List<SearchGuardRolesMapping.RolesMapping> build() {
        for (String role : this.roles.keySet()) {
            SearchGuardRolesMapping.RolesMapping mapping = new SearchGuardRolesMapping.RolesMapping();
            mapping.setName(role);
            mapping.setUsers(new ArrayList<String>((Collection)this.roles.get(role)));
            this.rolesMappings.add(mapping);
        }
        return this.rolesMappings;
    }

    public RolesMappingBuilder addRole(String role) {
        this.roles.put(role, new HashSet());
        return this;
    }

    public RolesMappingBuilder setUsers(String role, List<String> users) {
        this.roles.put(role, new HashSet<String>(users));
        return this;
    }

    public RolesMappingBuilder addUser(String role, String user) {
        if (!this.roles.containsKey(role)) {
            this.addRole(role);
        }
        this.roles.get(role).add(user);
        return this;
    }
}

