/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "imagePullSecrets", "kind", "metadata", "secrets"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class ServiceAccount
implements HasMetadata {
    @NotNull
    @JsonProperty(value="apiVersion")
    private String apiVersion = "v1";
    @JsonProperty(value="imagePullSecrets")
    @Valid
    private List<LocalObjectReference> imagePullSecrets = new ArrayList<LocalObjectReference>();
    @NotNull
    @JsonProperty(value="kind")
    private String kind = "ServiceAccount";
    @JsonProperty(value="metadata")
    @Valid
    @CheckObjectMeta(regexp="^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$", max=253)
    private ObjectMeta metadata;
    @JsonProperty(value="secrets")
    @Valid
    private List<ObjectReference> secrets = new ArrayList<ObjectReference>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ServiceAccount() {
    }

    public ServiceAccount(String apiVersion, List<LocalObjectReference> imagePullSecrets, String kind, ObjectMeta metadata, List<ObjectReference> secrets) {
        this.apiVersion = apiVersion;
        this.imagePullSecrets = imagePullSecrets;
        this.kind = kind;
        this.metadata = metadata;
        this.secrets = secrets;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="imagePullSecrets")
    public List<LocalObjectReference> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    @JsonProperty(value="imagePullSecrets")
    public void setImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="secrets")
    public List<ObjectReference> getSecrets() {
        return this.secrets;
    }

    @JsonProperty(value="secrets")
    public void setSecrets(List<ObjectReference> secrets) {
        this.secrets = secrets;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "ServiceAccount(apiVersion=" + this.getApiVersion() + ", imagePullSecrets=" + this.getImagePullSecrets() + ", kind=" + this.getKind() + ", metadata=" + this.getMetadata() + ", secrets=" + this.getSecrets() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceAccount)) {
            return false;
        }
        ServiceAccount other = (ServiceAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        List<LocalObjectReference> this$imagePullSecrets = this.getImagePullSecrets();
        List<LocalObjectReference> other$imagePullSecrets = other.getImagePullSecrets();
        if (this$imagePullSecrets == null ? other$imagePullSecrets != null : !((Object)this$imagePullSecrets).equals(other$imagePullSecrets)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        ObjectMeta this$metadata = this.getMetadata();
        ObjectMeta other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        List<ObjectReference> this$secrets = this.getSecrets();
        List<ObjectReference> other$secrets = other.getSecrets();
        if (this$secrets == null ? other$secrets != null : !((Object)this$secrets).equals(other$secrets)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceAccount;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        List<LocalObjectReference> $imagePullSecrets = this.getImagePullSecrets();
        result = result * 59 + ($imagePullSecrets == null ? 43 : ((Object)$imagePullSecrets).hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        ObjectMeta $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        List<ObjectReference> $secrets = this.getSecrets();
        result = result * 59 + ($secrets == null ? 43 : ((Object)$secrets).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

