/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import com.floragunn.searchguard.SearchGuardPlugin;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.ssl.SearchGuardSSLPlugin;
import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRoles;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRolesMapping;
import io.fabric8.elasticsearch.plugin.acl.UserProjectCache;
import io.fabric8.elasticsearch.plugin.kibana.KibanaSeed;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectList;
import io.fabric8.openshift.api.model.SubjectAccessReview;
import io.fabric8.openshift.api.model.SubjectAccessReviewBuilder;
import io.fabric8.openshift.api.model.SubjectAccessReviewResponse;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestFilter;
import org.elasticsearch.rest.RestFilterChain;
import org.elasticsearch.rest.RestRequest;

public class DynamicACLFilter
extends RestFilter
implements ConfigurationSettings {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private final ESLogger logger;
    private final UserProjectCache cache;
    private final String proxyUserHeader;
    private final Client esClient;
    private final String searchGuardIndex;
    private final String kibanaIndex;
    private final String kibanaVersion;
    private final String userProfilePrefix;
    private final Settings settings;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition syncing = this.lock.newCondition();
    private final String kbnVersionHeader;
    private final String[] operationsProjects;
    private Boolean enabled;
    private Boolean seeded;

    @Inject
    public DynamicACLFilter(UserProjectCache cache, Settings settings, Client client) {
        this.cache = cache;
        this.logger = Loggers.getLogger(this.getClass(), (Settings)settings, (String[])new String[0]);
        this.proxyUserHeader = settings.get("searchguard.authentication.proxy.header", "X-Proxy-Remote-User");
        this.searchGuardIndex = settings.get("searchguard.config_index_name", "searchguard");
        this.userProfilePrefix = settings.get("io.fabric8.elasticsearch.acl.user_profile_prefix", ".kibana");
        this.kibanaIndex = settings.get("kibana.config_index_name", ".kibana");
        this.kibanaVersion = settings.get("kibana.version", "4.5.1");
        this.kbnVersionHeader = settings.get("kibana.version.header", "kbn-version");
        this.operationsProjects = settings.getAsArray("openshift.operations.project.names", DEFAULT_OPENSHIFT_OPS_PROJECTS);
        this.logger.debug("searchGuardIndex: {}", new Object[]{this.searchGuardIndex});
        this.settings = settings;
        this.seeded = false;
        this.enabled = settings.getAsBoolean("openshift.acl.dynamic.enabled", Boolean.valueOf(true));
        System.setProperty("sg.nowarn.client", "true");
        String clusterName = settings.get("cluster.name");
        String keystore = settings.get("openshift.searchguard.keystore.path", "/usr/share/elasticsearch/config/admin.jks");
        String truststore = settings.get("openshift.searchguard.truststore.path", "/usr/share/elasticsearch/config/logging-es.truststore.jks");
        String kspass = settings.get("openshift.searchguard.keystore.password", "kspass");
        String tspass = settings.get("openshift.searchguard.truststore.password", "tspass");
        String kstype = settings.get("openshift.searchguard.keystore.type", "JKS");
        String tstype = settings.get("openshift.searchguard.truststore.type", "JKS");
        Settings.Builder settingsBuilder = Settings.builder().put("path.home", ".").put("path.conf", ".").put("searchguard.ssl.transport.keystore_filepath", keystore).put("searchguard.ssl.transport.truststore_filepath", truststore).put("searchguard.ssl.transport.keystore_password", kspass).put("searchguard.ssl.transport.truststore_password", tspass).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.keystore_type", kstype).put("searchguard.ssl.transport.truststore_type", tstype).put("cluster.name", clusterName).put("client.transport.ignore_cluster_name", false).put("client.transport.sniff", false);
        Settings clientSettings = settingsBuilder.build();
        this.esClient = TransportClient.builder().settings(clientSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build().addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress("localhost", 9300)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(RestRequest request, RestChannel channel, RestFilterChain chain) throws Exception {
        try {
            if (!this.seeded.booleanValue()) {
                try {
                    this.lock.lock();
                    this.seedInitialACL(this.esClient);
                    this.syncing.signalAll();
                }
                catch (Exception e) {
                    this.logger.error("Exception encountered when seeding initial ACL", (Throwable)e, new Object[0]);
                }
                finally {
                    this.lock.unlock();
                }
            }
            if (this.enabled.booleanValue()) {
                String kbnVersion = this.getKibanaVersion(request);
                if (StringUtils.isEmpty((String)kbnVersion)) {
                    kbnVersion = this.kibanaVersion;
                }
                String user = this.getUser(request);
                String token = this.getBearerToken(request);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Handling Request...", new Object[0]);
                    this.logger.debug("Evaluating request for user '{}' with a {} token", new Object[]{user, StringUtils.isNotEmpty((String)token) ? "non-empty" : "empty"});
                    this.logger.debug("Cache has user: {}", new Object[]{this.cache.hasUser(user)});
                }
                if (StringUtils.isNotEmpty((String)token) && StringUtils.isNotEmpty((String)user) && !this.cache.hasUser(user)) {
                    boolean isClusterAdmin = this.isClusterAdmin(token);
                    if (isClusterAdmin) {
                        request.putInContext((Object)"X-OpenShift-Roles", (Object)"cluster-admin");
                    }
                    if (this.updateCache(user, token, isClusterAdmin, kbnVersion)) {
                        this.syncAcl();
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error handling request in {}", (Throwable)e, new Object[]{this.getClass().getSimpleName()});
        }
        finally {
            chain.continueProcessing(request, channel);
        }
    }

    private String getUser(RestRequest request) {
        return (String)ObjectUtils.defaultIfNull((Object)request.header(this.proxyUserHeader), (Object)"");
    }

    private String getBearerToken(RestRequest request) {
        String[] auth = ((String)ObjectUtils.defaultIfNull((Object)request.header(AUTHORIZATION_HEADER), (Object)"")).split(" ");
        if (auth.length >= 2 && "Bearer".equals(auth[0])) {
            return auth[1];
        }
        return "";
    }

    private String getKibanaVersion(RestRequest request) {
        return (String)ObjectUtils.defaultIfNull((Object)request.header(this.kbnVersionHeader), (Object)"");
    }

    private boolean updateCache(String user, String token, boolean isClusterAdmin, String kbnVersion) {
        this.logger.debug("Updating the cache for user '{}'", new Object[]{user});
        try {
            Set<String> projects = this.listProjectsFor(token);
            this.cache.update(user, projects, isClusterAdmin);
            HashSet<String> roles = new HashSet<String>();
            if (isClusterAdmin) {
                roles.add("cluster-admin");
            }
            KibanaSeed.setDashboards(user, projects, roles, this.esClient, this.kibanaIndex, kbnVersion);
        }
        catch (Exception e) {
            this.logger.error("Error retrieving project list for '{}'", (Throwable)e, new Object[]{user});
            return false;
        }
        return true;
    }

    private Set<String> listProjectsFor(String token) throws Exception {
        ConfigBuilder builder = (ConfigBuilder)new ConfigBuilder().withOauthToken(token);
        HashSet<String> names = new HashSet<String>();
        try (DefaultOpenShiftClient client = new DefaultOpenShiftClient(builder.build());){
            List projects = ((ProjectList)client.projects().list()).getItems();
            for (Project project : projects) {
                if (this.isBlacklistProject(project.getMetadata().getName())) continue;
                names.add(project.getMetadata().getName() + "." + project.getMetadata().getUid());
            }
        }
        return names;
    }

    private boolean isBlacklistProject(String project) {
        return ArrayUtils.contains((Object[])this.operationsProjects, (Object)project.toLowerCase());
    }

    private boolean isClusterAdmin(String token) {
        ConfigBuilder builder = (ConfigBuilder)new ConfigBuilder().withOauthToken(token);
        try {
            DefaultOpenShiftClient osClient = new DefaultOpenShiftClient(builder.build());
            SubjectAccessReview request = ((SubjectAccessReviewBuilder)((SubjectAccessReviewBuilder)((SubjectAccessReviewBuilder)new SubjectAccessReviewBuilder().withVerb("*")).withResource("*")).withScopes(new ArrayList())).build();
            SubjectAccessReviewResponse response = (SubjectAccessReviewResponse)osClient.subjectAccessReviews().create((Object[])new SubjectAccessReview[]{request});
            osClient.close();
            this.logger.debug("isAdminResponse {}", new Object[]{response});
            return response.getAllowed();
        }
        catch (Exception e) {
            this.logger.error("Exception determining user's role.", (Throwable)e, new Object[0]);
            return false;
        }
    }

    private synchronized void syncAcl() {
        this.logger.debug("Syncing the ACL to ElasticSearch", new Object[0]);
        try {
            this.logger.debug("Loading SearchGuard ACL...", new Object[0]);
            SearchGuardRoles roles = this.readRolesACL(this.esClient);
            SearchGuardRolesMapping rolesMapping = this.readRolesMappingACL(this.esClient);
            this.logger.debug("Syncing from cache to ACL...", new Object[0]);
            roles.syncFrom(this.cache, this.userProfilePrefix);
            rolesMapping.syncFrom(this.cache, this.userProfilePrefix);
            this.writeACL(this.esClient, roles, rolesMapping);
        }
        catch (Exception e) {
            this.logger.error("Exception while syncing ACL with cache", (Throwable)e, new Object[0]);
        }
    }

    private SearchGuardRoles readRolesACL(Client esClient) throws IOException {
        GetRequest getRequest = (GetRequest)esClient.prepareGet(this.searchGuardIndex, "roles", "0").setRefresh(true).request();
        GetResponse response = (GetResponse)esClient.get(getRequest).actionGet();
        SearchGuardRoles roles = new SearchGuardRoles().load(response.getSource());
        this.logger.debug("Read in roles '{}'", new Object[]{roles});
        return roles;
    }

    private SearchGuardRolesMapping readRolesMappingACL(Client esClient) throws IOException {
        GetRequest getRequest = (GetRequest)esClient.prepareGet(this.searchGuardIndex, "rolesmapping", "0").setRefresh(true).request();
        GetResponse response = (GetResponse)esClient.get(getRequest).actionGet();
        SearchGuardRolesMapping rolesMapping = new SearchGuardRolesMapping().load(response.getSource());
        this.logger.debug("Read in rolesMapping '{}'", new Object[]{rolesMapping});
        return rolesMapping;
    }

    private void writeACL(Client esClient, SearchGuardRoles roles, SearchGuardRolesMapping rolesMapping) throws IOException {
        IndexRequest rolesIR = ((IndexRequest)new IndexRequest(this.searchGuardIndex).type("roles").id("0").refresh(true).consistencyLevel(WriteConsistencyLevel.DEFAULT)).source(roles.toMap());
        String rID = ((IndexResponse)esClient.index(rolesIR).actionGet()).getId();
        this.logger.debug("Built roles request: '{}'", new Object[]{rolesIR});
        this.logger.debug("Roles ID: '{}'", new Object[]{rID});
        IndexRequest mappingIR = ((IndexRequest)new IndexRequest(this.searchGuardIndex).type("rolesmapping").id("0").refresh(true).consistencyLevel(WriteConsistencyLevel.DEFAULT)).source(rolesMapping.toMap());
        String rmID = ((IndexResponse)esClient.index(mappingIR).actionGet()).getId();
        this.logger.debug("Built rolesMapping request: '{}'", new Object[]{mappingIR});
        this.logger.debug("rolesMapping ID: '{}'", new Object[]{rmID});
        String[] updateString = new String[]{"roles", "rolesmapping"};
        ConfigUpdateResponse cur = (ConfigUpdateResponse)esClient.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(updateString)).actionGet();
        if (((ConfigUpdateResponse.Node[])cur.getNodes()).length > 0) {
            this.logger.debug("Successfully reloaded config with '{}' nodes", new Object[]{((ConfigUpdateResponse.Node[])cur.getNodes()).length});
        } else {
            this.logger.warn("Failed to reloaded configs", new Object[]{((ConfigUpdateResponse.Node[])cur.getNodes()).length});
        }
    }

    private void createConfig(Client esClient) throws IOException {
        ClusterHealthResponse chr = (ClusterHealthResponse)esClient.admin().cluster().health(new ClusterHealthRequest().waitForYellowStatus()).actionGet();
        if (!chr.isTimedOut()) {
            ((CreateIndexResponse)esClient.admin().indices().create(new CreateIndexRequest().index(this.searchGuardIndex).settings(new Object[]{"index.number_of_shards", 1, "index.number_of_replicas", chr.getNumberOfDataNodes() - 1})).actionGet()).isAcknowledged();
            ClusterHealthRequest healthRequest = new ClusterHealthRequest().indices(new String[]{this.searchGuardIndex}).waitForYellowStatus();
            ((ClusterHealthResponse)esClient.admin().cluster().health(healthRequest).actionGet()).getStatus();
            String cd = this.settings.get("searchguard.config.path", "/opt/app-root/src/sgconfig/");
            for (String type : SEARCHGUARD_INITIAL_CONFIGS) {
                String file = String.format("%ssg_%s.yml", cd, type);
                this.logger.debug("Using '{}' file to populate '{}' type", new Object[]{file, type});
                if (this.uploadFile(esClient, file, type)) continue;
                String failedSeed = String.format("'%s/%s/%s' with '%s'", this.searchGuardIndex, type, "0", file);
                this.logger.error("Was not able to seed {}", new Object[]{failedSeed});
            }
            ConfigUpdateResponse cur = (ConfigUpdateResponse)esClient.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(SEARCHGUARD_INITIAL_CONFIGS)).actionGet();
            this.logger.debug("Succeed seeding SG, all node's config updated? '{}'", new Object[]{((ConfigUpdateResponse.Node[])cur.getNodes()).length == chr.getNumberOfNodes()});
        }
    }

    private void seedInitialACL(Client esClient) throws Exception {
        SearchGuardRoles roles = new SearchGuardRoles();
        SearchGuardRolesMapping rolesMapping = new SearchGuardRolesMapping();
        try {
            if (((IndicesExistsResponse)esClient.admin().indices().exists(new IndicesExistsRequest().indices(new String[]{this.searchGuardIndex})).actionGet()).isExists()) {
                roles = this.readRolesACL(esClient);
                rolesMapping = this.readRolesMappingACL(esClient);
                if (roles.iterator().hasNext() || rolesMapping.iterator().hasNext()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Have already seeded", new Object[0]);
                    }
                    this.seeded = true;
                    return;
                }
            }
        }
        catch (NoNodeAvailableException e) {
            this.logger.warn("Trying to seed ACL when ES has not not yet started: '{}'", new Object[]{e.getMessage()});
            return;
        }
        catch (NullPointerException | IndexNotFoundException | DocumentMissingException e) {
            this.logger.debug("Caught Exception, ACL has not been seeded yet", e, new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("Error checking ACL when seeding", (Throwable)e, new Object[0]);
            throw e;
        }
        try {
            this.createConfig(esClient);
        }
        catch (Exception e) {
            this.logger.error("Error seeding initial ACL", (Throwable)e, new Object[0]);
            throw e;
        }
        this.seeded = true;
    }

    public int order() {
        return Integer.MIN_VALUE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean uploadFile(Client tc, String filepath, String type) {
        try (FileReader reader = new FileReader(filepath);){
            String id = ((IndexResponse)tc.index(((IndexRequest)new IndexRequest(this.searchGuardIndex).type(type).id("0").refresh(true).consistencyLevel(WriteConsistencyLevel.DEFAULT)).source(this.readXContent(reader, XContentType.YAML))).actionGet()).getId();
            if ("0".equals(id)) {
                boolean bl = true;
                return bl;
            }
            this.logger.warn("Configuration for '{}' failed for unknown reasons", new Object[]{type});
            return false;
        }
        catch (IOException e) {
            this.logger.error("Configuration for '{}' failed due to '{}'", new Object[]{type, e});
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BytesReference readXContent(Reader reader, XContentType xContentType) throws IOException {
        try (XContentParser parser = null;){
            parser = XContentFactory.xContent((XContentType)xContentType).createParser(reader);
            parser.nextToken();
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.copyCurrentStructure(parser);
            BytesReference bytesReference = builder.bytes();
            return bytesReference;
        }
    }
}

