/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.filter;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.auth.BackendRegistry;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.DlsFlsRequestValve;
import com.floragunn.searchguard.configuration.PrivilegesEvaluator;
import com.floragunn.searchguard.support.HeaderHelper;
import com.floragunn.searchguard.user.User;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;

public class SearchGuardFilter
implements ActionFilter {
    protected final ESLogger log = Loggers.getLogger(this.getClass());
    private final Provider<PrivilegesEvaluator> evalp;
    private final Settings settings;
    private final AdminDNs adminDns;
    private Provider<DlsFlsRequestValve> dlsFlsValve;
    private final AuditLog auditLog;

    @Inject
    public SearchGuardFilter(Settings settings, Provider<PrivilegesEvaluator> evalp, AdminDNs adminDns, Provider<BackendRegistry> backendRegistry, Provider<DlsFlsRequestValve> dlsFlsValve, AuditLog auditLog) {
        this.settings = settings;
        this.evalp = evalp;
        this.adminDns = adminDns;
        this.dlsFlsValve = dlsFlsValve;
        this.auditLog = auditLog;
    }

    public int order() {
        return Integer.MIN_VALUE;
    }

    public void apply(Task task, String action, ActionRequest request, ActionListener listener, ActionFilterChain chain) {
        User user;
        if (this.log.isTraceEnabled()) {
            this.log.trace("Action {} from {}/{}", new Object[]{action, request.remoteAddress(), listener.getClass().getSimpleName()});
            this.log.trace("Context {}", new Object[]{request.getContext()});
            this.log.trace("Header {}", new Object[]{request.getHeaders()});
        }
        if ((user = (User)request.getFromContext((Object)"_sg_user")) == null && request.remoteAddress() == null) {
            user = User.SG_INTERNAL;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("remote address: {}", new Object[]{request.getFromContext((Object)"_sg_remote_address")});
        }
        if (SearchGuardFilter.isUserAdmin(user, this.adminDns) || SearchGuardFilter.isInterClusterRequest(request) || "true".equals(HeaderHelper.getSafeFromHeader((TransportRequest)request, "_sg_conf_request"))) {
            if (!((DlsFlsRequestValve)this.dlsFlsValve.get()).invoke(request, listener)) {
                return;
            }
            chain.proceed(task, action, request, listener);
            return;
        }
        if (User.SG_INTERNAL.equals(user)) {
            if (action.startsWith("internal:gateway") || action.startsWith("cluster:monitor/") || action.startsWith("indices:monitor/") || action.startsWith("cluster:admin/reroute") || action.startsWith("indices:admin/mapping/put") || action.startsWith("internal:cluster/nodes/indices/shard/store")) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("No user, will allow only standard discovery and monitoring actions", new Object[0]);
                }
                chain.proceed(task, action, request, listener);
                return;
            }
            this.log.debug("unauthenticated request {} for user {}", new Object[]{action, user});
            this.auditLog.logFailedLogin(user.getName(), (TransportRequest)request);
            listener.onFailure((Throwable)new ElasticsearchException("unauthenticated request " + action + " for user " + user, new Object[]{RestStatus.FORBIDDEN}));
            return;
        }
        PrivilegesEvaluator eval = (PrivilegesEvaluator)this.evalp.get();
        if (!eval.isInitialized()) {
            this.log.error("Search Guard not initialized (SG11) for {}", new Object[]{action});
            listener.onFailure((Throwable)new ElasticsearchException("Search Guard not initialized (SG11) for " + action, new Object[]{RestStatus.SERVICE_UNAVAILABLE}));
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Evaluate permissions for user: {}", new Object[]{user.getName()});
        }
        if (eval.evaluate(user, action, request)) {
            if (!((DlsFlsRequestValve)this.dlsFlsValve.get()).invoke(request, listener)) {
                return;
            }
            this.auditLog.logAuthenticatedRequest((TransportRequest)request, action);
            chain.proceed(task, action, request, listener);
            return;
        }
        this.auditLog.logMissingPrivileges(action, (TransportRequest)request);
        this.log.debug("no permissions for {}", new Object[]{action});
        listener.onFailure((Throwable)new ElasticsearchSecurityException("no permissions for " + action, RestStatus.FORBIDDEN, new Object[0]));
    }

    public void apply(String action, ActionResponse response, ActionListener listener, ActionFilterChain chain) {
        chain.proceed(action, response, listener);
    }

    private static boolean isInterClusterRequest(ActionRequest request) {
        return request.getFromContext((Object)"_sg_ssl_transport_intercluster_request") == Boolean.TRUE;
    }

    private static boolean isUserAdmin(User user, AdminDNs adminDns) {
        return user != null && adminDns.isAdmin(user.getName());
    }
}

