/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.user;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class AuthCredentials {
    private final String username;
    private byte[] password;
    private Object nativeCredentials;
    private final Set<String> backendRoles = new HashSet<String>();
    private boolean complete;
    private final int internalPasswordHash;

    public AuthCredentials(String username, Object nativeCredentials) {
        this(username, null, nativeCredentials, new String[0]);
        if (nativeCredentials == null) {
            throw new IllegalArgumentException("nativeCredentials must not be null or empty");
        }
    }

    public AuthCredentials(String username, byte[] password) {
        this(username, password, null, new String[0]);
        if (password == null || password.length == 0) {
            throw new IllegalArgumentException("password must not be null or empty");
        }
    }

    public AuthCredentials(String username, String ... backendRoles) {
        this(username, null, (Object)null, backendRoles);
    }

    public AuthCredentials(AuthCredentials creds) {
        this(creds.username, creds.password, creds.nativeCredentials, new String[0]);
    }

    private AuthCredentials(String username, byte[] password, Object nativeCredentials, String ... backendRoles) {
        if (username == null || username.isEmpty()) {
            throw new IllegalArgumentException("username must not be null or empty");
        }
        this.username = username;
        this.password = password == null ? null : Arrays.copyOf(password, password.length);
        this.internalPasswordHash = Arrays.hashCode(this.password);
        password = null;
        this.nativeCredentials = nativeCredentials;
        nativeCredentials = null;
        if (backendRoles != null && backendRoles.length > 0) {
            this.backendRoles.addAll(Arrays.asList(backendRoles));
        }
    }

    public void clearSecrets() {
        if (this.password != null) {
            Arrays.fill(this.password, (byte)0);
            this.password = null;
        }
        this.nativeCredentials = null;
    }

    public String getUsername() {
        return this.username;
    }

    public byte[] getPassword() {
        return this.password == null ? null : Arrays.copyOf(this.password, this.password.length);
    }

    public Object getNativeCredentials() {
        return this.nativeCredentials;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.internalPasswordHash;
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthCredentials other = (AuthCredentials)obj;
        if (this.internalPasswordHash != other.internalPasswordHash) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    public String toString() {
        return "AuthCredentials [username=" + this.username + ", password empty=" + (this.password == null) + ", nativeCredentials empty=" + (this.nativeCredentials == null) + ",backendRoles=" + this.backendRoles + "]";
    }

    public Set<String> getBackendRoles() {
        return new HashSet<String>(this.backendRoles);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public AuthCredentials markComplete() {
        this.complete = true;
        return this;
    }
}

