/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.support;

import com.google.common.io.BaseEncoding;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.xml.bind.DatatypeConverter;
import org.elasticsearch.ElasticsearchException;

public class Base64Helper {
    public static String encodeBasicHeader(String username, String password) {
        return new String(DatatypeConverter.printBase64Binary((byte[])(username + ":" + Objects.requireNonNull(password)).getBytes(StandardCharsets.UTF_8)));
    }

    public static String serializeObject(Serializable object) {
        if (object == null) {
            throw new IllegalArgumentException("object must not be null");
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(object);
            byte[] bytes = bos.toByteArray();
            return BaseEncoding.base64().encode(bytes);
        }
        catch (Exception e) {
            throw new ElasticsearchException(e.toString(), new Object[0]);
        }
    }

    public static Serializable deserializeObject(String string) {
        if (string == null) {
            throw new IllegalArgumentException("string must not be null");
        }
        try {
            byte[] userr = BaseEncoding.base64().decode((CharSequence)string);
            ByteArrayInputStream bis = new ByteArrayInputStream(userr);
            ObjectInputStream in = new ObjectInputStream(bis);
            return (Serializable)in.readObject();
        }
        catch (Exception e) {
            throw new ElasticsearchException(e.toString(), new Object[0]);
        }
    }
}

