/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.http;

import com.floragunn.searchguard.auth.HTTPAuthenticator;
import com.floragunn.searchguard.user.AuthCredentials;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;

public class HTTPClientCertAuthenticator
implements HTTPAuthenticator {
    protected final ESLogger log = Loggers.getLogger(this.getClass());
    private volatile Settings settings;

    public HTTPClientCertAuthenticator(Settings settings) {
        this.settings = settings;
    }

    @Override
    public AuthCredentials extractCredentials(RestRequest request) {
        String principal = (String)request.getFromContext((Object)"_sg_ssl_principal");
        if (!Strings.isNullOrEmpty((String)principal)) {
            return new AuthCredentials(principal, new String[0]).markComplete();
        }
        this.log.trace("No CLIENT CERT, send 401", new Object[0]);
        return null;
    }

    @Override
    public boolean reRequestAuthentication(RestChannel channel, AuthCredentials creds) {
        return false;
    }

    @Override
    public String getType() {
        return "clientcert";
    }
}

