/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import java.util.Objects;
import org.elasticsearch.transport.TransportRequest;

public class RequestHolder {
    private static final ThreadLocal<RequestHolder> current = new ThreadLocal();
    private final TransportRequest request;

    public static RequestHolder current() {
        return current.get();
    }

    public static void setCurrent(RequestHolder value) {
        current.set(Objects.requireNonNull(value));
    }

    public static void removeCurrent() {
        current.remove();
    }

    public RequestHolder(TransportRequest request) {
        this.request = Objects.requireNonNull(request);
    }

    public TransportRequest getRequest() {
        return this.request;
    }

    public String toString() {
        return "RequestHolder [request=" + this.request == null ? null : this.request.getContext() + "]";
    }
}

