/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.loader.JsonSettingsLoader;
import org.elasticsearch.common.xcontent.XContentHelper;

public class ConfigurationLoader {
    protected final ESLogger log = Loggers.getLogger(this.getClass());
    private final Provider<Client> client;

    @Inject
    public ConfigurationLoader(Provider<Client> client) {
        this.client = client;
    }

    public Map<String, Settings> load(String[] events) {
        HashMap<String, Settings> rs = new HashMap<String, Settings>(events.length);
        final ArrayBlockingQueue queue = new ArrayBlockingQueue(events.length);
        MultiGetRequest mget = new MultiGetRequest();
        for (int i = 0; i < events.length; ++i) {
            String event = events[i];
            mget.add("searchguard", event, "0");
        }
        mget.putHeader("_sg_conf_request", (Object)"true");
        mget.refresh(true);
        mget.realtime(Boolean.valueOf(true));
        ((Client)this.client.get()).multiGet(mget, (ActionListener)new ActionListener<MultiGetResponse>(){

            public void onResponse(MultiGetResponse mresponse) {
                MultiGetItemResponse[] mres = mresponse.getResponses();
                for (int i = 0; i < mres.length; ++i) {
                    GetResponse response = mres[i].getResponse();
                    if (response == null) {
                        try {
                            queue.put("failure " + mres[i].getType() + " " + mres[i].getFailure().getMessage());
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                    if (response.isExists() && !response.isSourceEmpty()) {
                        try {
                            queue.put(response);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                    try {
                        queue.put(response.getType());
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }

            public void onFailure(Throwable e) {
                try {
                    queue.put(e);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        Object response = null;
        try {
            response = queue.poll(10L, TimeUnit.SECONDS);
            if (queue.size() == 0 && response != null && response instanceof Throwable) {
                throw ExceptionsHelper.convertToElastic((Throwable)((Throwable)response));
            }
            if (response instanceof GetResponse && response != null) {
                GetResponse gs = (GetResponse)response;
                if (gs.isExists() && !gs.isSourceEmpty()) {
                    rs.put(gs.getType(), ConfigurationLoader.toSettings(gs.getSourceAsBytesRef()));
                }
            } else if (response != null && response.toString().contains("fail")) {
                this.log.debug("Cannot retrieve {}", new Object[]{response});
            } else {
                this.log.debug("Cannot retrieve {}", new Object[]{response});
            }
            for (int i = 0; i < events.length - 1; ++i) {
                response = queue.poll(10L, TimeUnit.SECONDS);
                if (response instanceof GetResponse && response != null) {
                    GetResponse gs = (GetResponse)response;
                    if (!gs.isExists() || gs.isSourceEmpty()) continue;
                    rs.put(gs.getType(), ConfigurationLoader.toSettings(gs.getSourceAsBytesRef()));
                    continue;
                }
                if (response != null && response.toString().contains("fail")) {
                    this.log.debug("Cannot retrieve {}", new Object[]{response});
                    continue;
                }
                this.log.debug("Cannot retrieve {}", new Object[]{response});
            }
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
            throw ExceptionsHelper.convertToElastic((Throwable)e1);
        }
        return rs;
    }

    private static Settings toSettings(BytesReference ref) {
        if (ref == null || ref.length() == 0) {
            throw new ElasticsearchException("ref invalid", new Object[0]);
        }
        try {
            return Settings.builder().put(new JsonSettingsLoader().load(XContentHelper.createParser((BytesReference)ref))).build();
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic((Throwable)e);
        }
    }
}

