/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.auth.internal;

import com.floragunn.searchguard.action.configupdate.TransportConfigUpdateAction;
import com.floragunn.searchguard.auth.AuthenticationBackend;
import com.floragunn.searchguard.configuration.ConfigChangeListener;
import com.floragunn.searchguard.crypto.BCrypt;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import java.util.Arrays;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class InternalAuthenticationBackend
implements AuthenticationBackend,
ConfigChangeListener {
    private volatile Settings br;

    @Inject
    public InternalAuthenticationBackend(Settings unused, TransportConfigUpdateAction tcua) {
        tcua.addConfigChangeListener("internalusers", this);
    }

    @Override
    public boolean exists(User user) {
        String[] roles;
        if (!this.isInitialized()) {
            return false;
        }
        String hashed = this.br.get(user.getName() + ".hash");
        if (hashed == null) {
            for (String username : this.br.names()) {
                String u = this.br.get(username + ".username");
                if (!user.getName().equals(u)) continue;
                hashed = this.br.get(username + ".hash");
                break;
            }
            if (hashed == null) {
                return false;
            }
        }
        if ((roles = this.br.getAsArray(user.getName() + ".roles", new String[0])) != null) {
            user.addRoles(Arrays.asList(roles));
        }
        return true;
    }

    @Override
    public User authenticate(AuthCredentials credentials) {
        byte[] password;
        if (!this.isInitialized()) {
            throw new ElasticsearchSecurityException("Internal authentication backend not configured. May be Search Guard is not initialized.", new Object[0]);
        }
        String hashed = this.br.get(credentials.getUsername() + ".hash");
        if (hashed == null) {
            for (String username : this.br.names()) {
                String u = this.br.get(username + ".username");
                if (!credentials.getUsername().equals(u)) continue;
                hashed = this.br.get(username + ".hash");
                break;
            }
            if (hashed == null) {
                throw new ElasticsearchSecurityException(credentials.getUsername() + " not found", new Object[0]);
            }
        }
        if ((password = credentials.getPassword()) == null || password.length == 0) {
            throw new ElasticsearchSecurityException("empty passwords not supported", new Object[0]);
        }
        if (BCrypt.checkpw(password, hashed)) {
            String[] roles = this.br.getAsArray(credentials.getUsername() + ".roles", new String[0]);
            return new User(credentials.getUsername(), Arrays.asList(roles));
        }
        throw new ElasticsearchSecurityException("password does not match", new Object[0]);
    }

    @Override
    public String getType() {
        return "internal";
    }

    @Override
    public void onChange(String event, Settings settings) {
        this.br = settings;
    }

    @Override
    public void validate(String event, Settings settings) throws ElasticsearchSecurityException {
    }

    @Override
    public boolean isInitialized() {
        return this.br != null;
    }
}

