/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.TransportConfigUpdateAction;
import com.floragunn.searchguard.auditlog.AuditLogModule;
import com.floragunn.searchguard.configuration.BackendModule;
import com.floragunn.searchguard.configuration.ConfigurationModule;
import com.floragunn.searchguard.configuration.SearchGuardIndexSearcherWrapperModule;
import com.floragunn.searchguard.filter.SearchGuardFilter;
import com.floragunn.searchguard.http.SearchGuardHttpServerTransport;
import com.floragunn.searchguard.rest.SearchGuardInfoAction;
import com.floragunn.searchguard.transport.SearchGuardTransportService;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import org.elasticsearch.action.ActionModule;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.HttpServerModule;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestModule;
import org.elasticsearch.transport.TransportModule;

public final class SearchGuardPlugin
extends Plugin {
    private static final String CLIENT_TYPE = "client.type";
    private final Settings settings;
    private final boolean client;
    private final boolean httpSSLEnabled;

    public SearchGuardPlugin(Settings settings) {
        this.checkSSLPluginAvailable();
        if (!settings.getAsBoolean("searchguard.ssl.transport.enabled", Boolean.valueOf(true)).booleanValue()) {
            throw new IllegalStateException("searchguard.ssl.transport.enabled must be set to 'true'");
        }
        this.settings = settings;
        this.client = !"node".equals(this.settings.get(CLIENT_TYPE, "node"));
        this.httpSSLEnabled = settings.getAsBoolean("searchguard.ssl.http.enabled", Boolean.valueOf(false));
        if (this.client && System.getProperty("sg.nowarn.client") == null) {
            System.out.println("*************************************************************");
            System.out.println("'Search Guard 2' plugin must not be installed on client nodes.");
            System.out.println("'Search Guard SSL' plugin is enough");
            System.out.println("*************************************************************");
        }
    }

    public String name() {
        return "search-guard2";
    }

    public String description() {
        return "Search Guard 2";
    }

    public Collection<Module> shardModules(Settings settings) {
        if (!this.client) {
            return ImmutableList.of((Object)((Object)new SearchGuardIndexSearcherWrapperModule()));
        }
        return ImmutableList.of();
    }

    public Collection<Module> nodeModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        if (!this.client) {
            modules.add((Module)new ConfigurationModule());
            modules.add((Module)new BackendModule());
            modules.add((Module)new AuditLogModule());
        }
        return modules;
    }

    public void onModule(ActionModule module) {
        module.registerAction((GenericAction)ConfigUpdateAction.INSTANCE, TransportConfigUpdateAction.class, new Class[0]);
        if (!this.client) {
            module.registerFilter(SearchGuardFilter.class);
        }
    }

    public void onModule(RestModule module) {
        if (!this.client) {
            module.addRestAction(SearchGuardInfoAction.class);
        }
    }

    public void onModule(TransportModule module) {
        if (!this.client) {
            module.setTransportService(SearchGuardTransportService.class, this.name());
        }
    }

    public void onModule(HttpServerModule module) {
        if (!this.client && this.httpSSLEnabled) {
            module.setHttpServerTransport(SearchGuardHttpServerTransport.class, this.name());
        }
    }

    public Settings additionalSettings() {
        Settings.Builder builder = Settings.settingsBuilder();
        return builder.build();
    }

    private void checkSSLPluginAvailable() {
        try {
            ((Object)((Object)this)).getClass().getClassLoader().loadClass("com.floragunn.searchguard.ssl.SearchGuardSSLPlugin");
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("SearchGuardSSLPlugin must be be installed");
        }
    }
}

