/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.kibana;

import io.fabric8.elasticsearch.plugin.KibanaUserReindexFilter;
import io.fabric8.elasticsearch.plugin.kibana.DocumentBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.transport.RemoteTransportException;

public class KibanaSeed {
    private static ESLogger logger = Loggers.getLogger(KibanaSeed.class);
    private static final String DEFAULT_INDEX_TYPE = "config";
    private static final String INDICIES_TYPE = "index-pattern";
    private static final String OPERATIONS_PROJECT = ".operations";
    private static final String BLANK_PROJECT = ".empty-project";
    private static final String ADMIN_ALIAS_NAME = ".all";
    private static final String[] OPERATIONS_ROLES = new String[]{"cluster-admin"};
    public static final String DEFAULT_INDEX_FIELD = "defaultIndex";

    public static void setDashboards(String user, Set<String> projects, Set<String> roles, Client esClient, String kibanaIndex, String kibanaVersion) {
        AtomicBoolean changed = new AtomicBoolean(KibanaSeed.initialSeedKibanaIndex(user, kibanaIndex, esClient));
        boolean isAdmin = false;
        Set<String> indexPatterns = KibanaSeed.getIndexPatterns(user, esClient, kibanaIndex);
        logger.debug("Found '{}' Index patterns for user", new Object[]{indexPatterns.size()});
        logger.debug("Checking for '{}' in users roles '{}'", new Object[]{OPERATIONS_ROLES, roles});
        for (String role : OPERATIONS_ROLES) {
            if (!roles.contains(role)) continue;
            logger.debug("{} is an admin user", new Object[]{user});
            projects.add(OPERATIONS_PROJECT);
            isAdmin = true;
            projects.add(ADMIN_ALIAS_NAME);
            break;
        }
        ArrayList<String> sortedProjects = new ArrayList<String>(projects);
        Collections.sort(sortedProjects);
        if (sortedProjects.isEmpty()) {
            sortedProjects.add(BLANK_PROJECT);
        }
        logger.debug("Setting dashboards given user '{}' and projects '{}'", new Object[]{user, projects});
        if (isAdmin) {
            logger.debug("Adding to alias for {}", new Object[]{user});
            KibanaSeed.buildAdminAlias(user, sortedProjects, esClient, kibanaIndex, kibanaVersion);
        }
        if (indexPatterns.isEmpty()) {
            KibanaSeed.create(user, sortedProjects, true, esClient, kibanaIndex, kibanaVersion);
            changed.set(true);
        } else {
            ArrayList<String> common = new ArrayList<String>(indexPatterns);
            common.retainAll(sortedProjects);
            sortedProjects.removeAll(common);
            indexPatterns.removeAll(common);
            if (sortedProjects.size() > 0 || indexPatterns.size() > 0) {
                changed.set(true);
            }
            KibanaSeed.create(user, sortedProjects, false, esClient, kibanaIndex, kibanaVersion);
            KibanaSeed.remove(user, indexPatterns, esClient, kibanaIndex);
            common.addAll(sortedProjects);
            Collections.sort(common);
            String defaultIndex = KibanaSeed.getDefaultIndex(user, esClient, kibanaIndex, kibanaVersion);
            logger.debug("Checking if '{}' contains '{}'", new Object[]{indexPatterns, defaultIndex});
            if (indexPatterns.contains(defaultIndex) || StringUtils.isEmpty((String)defaultIndex)) {
                logger.debug("'{}' does contain '{}' and common size is {}", new Object[]{indexPatterns, defaultIndex, common.size()});
                if (common.size() > 0) {
                    KibanaSeed.setDefaultIndex(user, (String)common.get(0), esClient, kibanaIndex, kibanaVersion);
                }
            }
        }
        if (changed.get()) {
            KibanaSeed.refreshKibanaUser(user, kibanaIndex, esClient);
        }
    }

    private static void refreshKibanaUser(String username, String kibanaIndex, Client esClient) {
        String userIndex = KibanaSeed.getKibanaIndex(username, kibanaIndex);
        RefreshRequest request = (RefreshRequest)new RefreshRequest().indices(new String[]{userIndex});
        RefreshResponse response = (RefreshResponse)esClient.admin().indices().refresh(request).actionGet();
        logger.debug("Refreshed '{}' successfully on {} of {} shards", new Object[]{userIndex, response.getSuccessfulShards(), response.getTotalShards()});
    }

    private static boolean initialSeedKibanaIndex(String username, String kibanaIndex, Client esClient) {
        try {
            String userIndex = KibanaSeed.getKibanaIndex(username, kibanaIndex);
            IndicesExistsResponse existsResponse = (IndicesExistsResponse)esClient.admin().indices().prepareExists(new String[]{userIndex}).get();
            logger.debug("Checking if index {} exists? {}", new Object[]{userIndex, existsResponse.isExists()});
            if (!existsResponse.isExists()) {
                logger.debug("Copying '{}' to '{}'", new Object[]{kibanaIndex, userIndex});
                GetIndexRequest getRequest = (GetIndexRequest)new GetIndexRequest().indices(new String[]{kibanaIndex});
                GetIndexResponse getResponse = (GetIndexResponse)esClient.admin().indices().getIndex(getRequest).get();
                CreateIndexRequest createRequest = new CreateIndexRequest().index(userIndex);
                createRequest.settings((Settings)getResponse.settings().get((Object)kibanaIndex));
                Map configMapping = ((MappingMetaData)((ImmutableOpenMap)getResponse.mappings().get((Object)kibanaIndex)).get((Object)DEFAULT_INDEX_TYPE)).getSourceAsMap();
                createRequest.mapping(DEFAULT_INDEX_TYPE, configMapping);
                esClient.admin().indices().create(createRequest).actionGet();
                ClusterHealthRequest healthRequest = new ClusterHealthRequest().indices(new String[]{userIndex}).waitForYellowStatus();
                ((ClusterHealthResponse)esClient.admin().cluster().health(healthRequest).actionGet()).getStatus();
                return true;
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            logger.error("Unable to create initial Kibana index", (Throwable)e, new Object[0]);
        }
        return false;
    }

    private static void setDefaultIndex(String username, String project, Client esClient, String kibanaIndex, String kibanaVersion) {
        String source = new DocumentBuilder().defaultIndex(KibanaSeed.getIndexPattern(project)).build();
        KibanaSeed.executeUpdate(KibanaSeed.getKibanaIndex(username, kibanaIndex), DEFAULT_INDEX_TYPE, kibanaVersion, source, esClient);
    }

    private static void buildAdminAlias(String username, List<String> projects, Client esClient, String kibanaIndex, String kibanaVersion) {
        ArrayList<String> toAdd = new ArrayList<String>(projects);
        try {
            for (String project : projects) {
                IndicesExistsResponse existsResponse = (IndicesExistsResponse)esClient.admin().indices().prepareExists(new String[]{KibanaSeed.getIndexPattern(project)}).get();
                logger.debug("Checking if index {} with pattern '{}' exists? {}", new Object[]{project, KibanaSeed.getIndexPattern(project), existsResponse.isExists()});
                if (existsResponse.isExists() && !project.equalsIgnoreCase(ADMIN_ALIAS_NAME)) continue;
                toAdd.remove(project);
            }
            if (toAdd.isEmpty()) {
                return;
            }
            IndicesAliasesRequestBuilder aliasBuilder = esClient.admin().indices().prepareAliases();
            for (String project : toAdd) {
                logger.debug("Creating alias for {} as {}", new Object[]{project, ADMIN_ALIAS_NAME});
                aliasBuilder.addAlias(KibanaSeed.getIndexPattern(project), ADMIN_ALIAS_NAME);
            }
            IndicesAliasesResponse response = (IndicesAliasesResponse)aliasBuilder.get();
            logger.debug("Aliases request acknowledged? {}", new Object[]{response.isAcknowledged()});
        }
        catch (ElasticsearchException e) {
            logger.error("Error executing Alias request", (Throwable)e, new Object[0]);
        }
    }

    private static String getDefaultIndex(String username, Client esClient, String kibanaIndex, String kibanaVersion) {
        GetRequest request = (GetRequest)esClient.prepareGet(KibanaSeed.getKibanaIndex(username, kibanaIndex), DEFAULT_INDEX_TYPE, kibanaVersion).request();
        try {
            GetResponse response = (GetResponse)esClient.get(request).get();
            Map source = response.getSource();
            if (source.containsKey(DEFAULT_INDEX_FIELD)) {
                logger.debug("Received response with 'defaultIndex' = {}", new Object[]{source.get(DEFAULT_INDEX_FIELD)});
                String index = (String)source.get(DEFAULT_INDEX_FIELD);
                return KibanaSeed.getProjectFromIndex(index);
            }
            logger.debug("Received response without 'defaultIndex'", new Object[0]);
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() instanceof RemoteTransportException && e.getCause().getCause() instanceof IndexNotFoundException) {
                logger.debug("No index found", new Object[0]);
            }
            logger.error("Error getting default index for {}", (Throwable)e, new Object[]{username});
        }
        return "";
    }

    private static void create(String user, List<String> projects, boolean setDefault, Client esClient, String kibanaIndex, String kibanaVersion) {
        boolean defaultSet = !setDefault;
        for (String project : projects) {
            KibanaSeed.createIndex(user, project, esClient, kibanaIndex);
            if (defaultSet) continue;
            KibanaSeed.setDefaultIndex(user, project, esClient, kibanaIndex, kibanaVersion);
            defaultSet = true;
        }
    }

    private static void remove(String user, Set<String> projects, Client esClient, String kibanaIndex) {
        for (String project : projects) {
            KibanaSeed.deleteIndex(user, project, esClient, kibanaIndex);
        }
    }

    private static Set<String> getIndexPatterns(String username, Client esClient, String kibanaIndex) {
        HashSet<String> patterns = new HashSet<String>();
        SearchRequest request = esClient.prepareSearch(new String[]{KibanaSeed.getKibanaIndex(username, kibanaIndex)}).setTypes(new String[]{INDICIES_TYPE}).request();
        try {
            SearchResponse response = (SearchResponse)esClient.search(request).get();
            if (response.getHits() != null && response.getHits().getTotalHits() > 0L) {
                for (SearchHit hit : response.getHits().getHits()) {
                    String id = hit.getId();
                    String project = KibanaSeed.getProjectFromIndex(id);
                    if (project.equals(id) && !project.equalsIgnoreCase(ADMIN_ALIAS_NAME)) continue;
                    patterns.add(project);
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() instanceof RemoteTransportException && e.getCause().getCause() instanceof IndexNotFoundException) {
                logger.debug("Encountered IndexMissingException, returning empty response", new Object[0]);
            }
            logger.error("Error getting index patterns for {}", (Throwable)e, new Object[]{username});
        }
        return patterns;
    }

    private static void createIndex(String username, String project, Client esClient, String kibanaIndex) {
        DocumentBuilder sourceBuilder = new DocumentBuilder().title(KibanaSeed.getIndexPattern(project)).timeFieldName("time");
        if (project.equalsIgnoreCase(OPERATIONS_PROJECT) || project.equalsIgnoreCase(ADMIN_ALIAS_NAME)) {
            sourceBuilder.operationsFields();
        } else if (project.equalsIgnoreCase(BLANK_PROJECT)) {
            sourceBuilder.blankFields();
        } else {
            sourceBuilder.applicationFields();
        }
        String source = sourceBuilder.build();
        KibanaSeed.executeCreate(KibanaSeed.getKibanaIndex(username, kibanaIndex), INDICIES_TYPE, KibanaSeed.getIndexPattern(project), source, esClient);
    }

    private static void deleteIndex(String username, String project, Client esClient, String kibanaIndex) {
        KibanaSeed.executeDelete(KibanaSeed.getKibanaIndex(username, kibanaIndex), INDICIES_TYPE, KibanaSeed.getIndexPattern(project), esClient);
    }

    private static void executeCreate(String index, String type, String id, String source, Client esClient) {
        logger.debug("CREATE: '{}/{}/{}' source: '{}'", new Object[]{index, type, id, source});
        IndexRequest request = (IndexRequest)esClient.prepareIndex(index, type, id).setSource(source).request();
        try {
            esClient.index(request).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Error executing create request", (Throwable)e, new Object[0]);
        }
    }

    private static void executeUpdate(String index, String type, String id, String source, Client esClient) {
        logger.debug("UPDATE: '{}/{}/{}' source: '{}'", new Object[]{index, type, id, source});
        UpdateRequest request = (UpdateRequest)esClient.prepareUpdate(index, type, id).setDoc(source).setDocAsUpsert(true).request();
        logger.debug("Created with update? '{}'", new Object[]{((UpdateResponse)esClient.update(request).actionGet()).isCreated()});
    }

    private static void executeDelete(String index, String type, String id, Client esClient) {
        logger.debug("DELETE: '{}/{}/{}'", new Object[]{index, type, id});
        DeleteRequest request = (DeleteRequest)esClient.prepareDelete(index, type, id).request();
        try {
            esClient.delete(request).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Error executing delete request", (Throwable)e, new Object[0]);
        }
    }

    private static String getKibanaIndex(String username, String kibanaIndex) {
        return kibanaIndex + "." + KibanaUserReindexFilter.getUsernameHash(username);
    }

    private static String getIndexPattern(String project) {
        if (project.equalsIgnoreCase(ADMIN_ALIAS_NAME)) {
            return project;
        }
        return project + ".*";
    }

    private static String getProjectFromIndex(String index) {
        if (!StringUtils.isEmpty((String)index)) {
            if (index.equalsIgnoreCase(ADMIN_ALIAS_NAME)) {
                return index;
            }
            int wildcard = index.lastIndexOf(46);
            if (wildcard > 0) {
                return index.substring(0, wildcard);
            }
        }
        return index;
    }
}

