/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.kibana;

import io.fabric8.elasticsearch.plugin.KibanaUserReindexFilter;
import io.fabric8.elasticsearch.plugin.kibana.DocumentBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.search.SearchHit;

public class KibanaSeed {
    private static ESLogger logger = Loggers.getLogger(KibanaSeed.class);
    private static final String DEFAULT_INDEX_TYPE = "config";
    private static final String INDICIES_TYPE = "index-pattern";
    private static final String OPERATIONS_PROJECT = ".operations";
    private static final String BLANK_PROJECT = ".empty-project";
    private static final String[] OPERATIONS_ROLES = new String[]{"cluster-admin"};
    private static final String[] BLACKLIST_PROJECTS = new String[]{"default", "openshift", "openshift-infra"};
    public static final String DEFAULT_INDEX_FIELD = "defaultIndex";

    public static void setDashboards(String user, Set<String> projects, Set<String> roles, Client esClient, String kibanaIndex, String kibanaVersion) {
        for (String project : BLACKLIST_PROJECTS) {
            if (!projects.contains(project)) continue;
            logger.debug("Black-listed project '{}' found.  Not adding as an index pattern", new Object[]{project});
            projects.remove(project);
        }
        Set<String> indexPatterns = KibanaSeed.getIndexPatterns(user, esClient, kibanaIndex);
        logger.debug("Found '{}' Index patterns for user", new Object[]{indexPatterns.size()});
        logger.debug("Checking for '{}' in users roles '{}'", new Object[]{OPERATIONS_ROLES, roles});
        for (String role : OPERATIONS_ROLES) {
            if (!roles.contains(role)) continue;
            logger.debug("{} is an admin user", new Object[]{user});
            projects.add(OPERATIONS_PROJECT);
            break;
        }
        ArrayList<String> sortedProjects = new ArrayList<String>(projects);
        Collections.sort(sortedProjects);
        if (sortedProjects.isEmpty()) {
            sortedProjects.add(BLANK_PROJECT);
        }
        logger.debug("Setting dashboards given user '{}' and projects '{}'", new Object[]{user, projects});
        if (indexPatterns.isEmpty()) {
            KibanaSeed.create(user, sortedProjects, true, esClient, kibanaIndex, kibanaVersion);
        } else {
            ArrayList<String> common = new ArrayList<String>(indexPatterns);
            common.retainAll(sortedProjects);
            sortedProjects.removeAll(common);
            indexPatterns.removeAll(common);
            KibanaSeed.create(user, sortedProjects, false, esClient, kibanaIndex, kibanaVersion);
            KibanaSeed.remove(user, indexPatterns, esClient, kibanaIndex);
            common.addAll(sortedProjects);
            Collections.sort(common);
            String defaultIndex = KibanaSeed.getDefaultIndex(user, esClient, kibanaIndex, kibanaVersion);
            logger.debug("Checking if '{}' contains '{}'", new Object[]{indexPatterns, defaultIndex});
            if (indexPatterns.contains(defaultIndex) || StringUtils.isEmpty((String)defaultIndex)) {
                logger.debug("'{}' does contain '{}' and common size is {}", new Object[]{indexPatterns, defaultIndex, common.size()});
                if (common.size() > 0) {
                    KibanaSeed.setDefaultIndex(user, (String)common.get(0), esClient, kibanaIndex, kibanaVersion);
                }
            }
        }
    }

    private static void setDefaultIndex(String username, String project, Client esClient, String kibanaIndex, String kibanaVersion) {
        String source = new DocumentBuilder().defaultIndex(KibanaSeed.getIndexPattern(project)).build();
        KibanaSeed.executeCreate(KibanaSeed.getKibanaIndex(username, kibanaIndex), DEFAULT_INDEX_TYPE, kibanaVersion, source, esClient);
    }

    private static String getDefaultIndex(String username, Client esClient, String kibanaIndex, String kibanaVersion) {
        GetRequest request = (GetRequest)esClient.prepareGet(KibanaSeed.getKibanaIndex(username, kibanaIndex), DEFAULT_INDEX_TYPE, kibanaVersion).request();
        try {
            GetResponse response = (GetResponse)esClient.get(request).get();
            Map source = response.getSource();
            if (source.containsKey(DEFAULT_INDEX_FIELD)) {
                logger.debug("Received response with 'defaultIndex' = {}", new Object[]{source.get(DEFAULT_INDEX_FIELD)});
                String index = (String)source.get(DEFAULT_INDEX_FIELD);
                return KibanaSeed.getProjectFromIndex(index);
            }
            logger.debug("Received response without 'defaultIndex'", new Object[0]);
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() instanceof IndexMissingException) {
                logger.debug("No index found", new Object[0]);
            }
            logger.error("Error getting default index for {}", (Throwable)e, new Object[]{username});
        }
        return "";
    }

    private static void create(String user, List<String> projects, boolean setDefault, Client esClient, String kibanaIndex, String kibanaVersion) {
        boolean defaultSet = !setDefault;
        for (String project : projects) {
            KibanaSeed.createIndex(user, project, esClient, kibanaIndex);
            if (defaultSet) continue;
            KibanaSeed.setDefaultIndex(user, project, esClient, kibanaIndex, kibanaVersion);
            defaultSet = true;
        }
    }

    private static void remove(String user, Set<String> projects, Client esClient, String kibanaIndex) {
        for (String project : projects) {
            KibanaSeed.deleteIndex(user, project, esClient, kibanaIndex);
        }
    }

    private static Set<String> getIndexPatterns(String username, Client esClient, String kibanaIndex) {
        HashSet<String> patterns = new HashSet<String>();
        SearchRequest request = esClient.prepareSearch(new String[]{KibanaSeed.getKibanaIndex(username, kibanaIndex)}).setTypes(new String[]{INDICIES_TYPE}).request();
        try {
            SearchResponse response = (SearchResponse)esClient.search(request).get();
            if (response.getHits() != null && response.getHits().getTotalHits() > 0L) {
                for (SearchHit hit : response.getHits().getHits()) {
                    String id = hit.getId();
                    String project = KibanaSeed.getProjectFromIndex(id);
                    if (project.equals(id)) continue;
                    patterns.add(project);
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() instanceof IndexMissingException) {
                logger.debug("Encountered IndexMissingException, returning empty response", new Object[0]);
            }
            logger.error("Error getting index patterns for {}", (Throwable)e, new Object[]{username});
        }
        return patterns;
    }

    private static void createIndex(String username, String project, Client esClient, String kibanaIndex) {
        DocumentBuilder sourceBuilder = new DocumentBuilder().title(KibanaSeed.getIndexPattern(project)).timeFieldName("time");
        if (project.equalsIgnoreCase(OPERATIONS_PROJECT)) {
            sourceBuilder.operationsFields();
        } else if (project.equalsIgnoreCase(BLANK_PROJECT)) {
            sourceBuilder.blankFields();
        } else {
            sourceBuilder.applicationFields();
        }
        String source = sourceBuilder.build();
        KibanaSeed.executeCreate(KibanaSeed.getKibanaIndex(username, kibanaIndex), INDICIES_TYPE, KibanaSeed.getIndexPattern(project), source, esClient);
    }

    private static void deleteIndex(String username, String project, Client esClient, String kibanaIndex) {
        KibanaSeed.executeDelete(KibanaSeed.getKibanaIndex(username, kibanaIndex), INDICIES_TYPE, KibanaSeed.getIndexPattern(project), esClient);
    }

    private static void executeCreate(String index, String type, String id, String source, Client esClient) {
        logger.debug("CREATE: '{}/{}/{}' source: '{}'", new Object[]{index, type, id, source});
        IndexRequest request = (IndexRequest)esClient.prepareIndex(index, type, id).setSource(source).request();
        try {
            esClient.index(request).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Error executing create request", (Throwable)e, new Object[0]);
        }
    }

    private static void executeDelete(String index, String type, String id, Client esClient) {
        logger.debug("DELETE: '{}/{}/{}'", new Object[]{index, type, id});
        DeleteRequest request = (DeleteRequest)esClient.prepareDelete(index, type, id).request();
        try {
            esClient.delete(request).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Error executing delete request", (Throwable)e, new Object[0]);
        }
    }

    private static String getKibanaIndex(String username, String kibanaIndex) {
        return kibanaIndex + "." + KibanaUserReindexFilter.getUsernameHash(username);
    }

    private static String getIndexPattern(String project) {
        return project + ".*";
    }

    private static String getProjectFromIndex(String index) {
        int wildcard;
        if (!StringUtils.isEmpty((String)index) && (wildcard = index.indexOf(42)) > 0) {
            return index.substring(0, wildcard - 1);
        }
        return index;
    }
}

