/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.mock;

import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerListBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientRollableScallableResource;
import io.fabric8.kubernetes.client.mock.KubernetesMockServerTestBase;
import org.junit.Assert;
import org.junit.Test;

public class ReplicationControllerTest
extends KubernetesMockServerTestBase {
    @Test
    public void testList() {
        this.expectAndReturnAsJson("/api/v1/namespaces/test/replicationcontrollers", 200, new ReplicationControllerListBuilder().build());
        this.expectAndReturnAsJson("/api/v1/namespaces/ns1/replicationcontrollers", 200, ((ReplicationControllerListBuilder)((ReplicationControllerListBuilder)new ReplicationControllerListBuilder().addNewItem().and()).addNewItem().and()).build());
        KubernetesClient client = this.getClient();
        ReplicationControllerList replicationControllerList = (ReplicationControllerList)client.replicationControllers().list();
        Assert.assertNotNull((Object)replicationControllerList);
        Assert.assertEquals((long)0L, (long)replicationControllerList.getItems().size());
        replicationControllerList = (ReplicationControllerList)((ClientNonNamespaceOperation)client.replicationControllers().inNamespace("ns1")).list();
        Assert.assertNotNull((Object)replicationControllerList);
        Assert.assertEquals((long)2L, (long)replicationControllerList.getItems().size());
    }

    @Test
    public void testGet() {
        this.expectAndReturnAsJson("/api/v1/namespaces/test/replicationcontrollers/repl1", 200, new ReplicationControllerBuilder().build());
        this.expectAndReturnAsJson("/api/v1/namespaces/ns1/replicationcontrollers/repl2", 200, new ReplicationControllerBuilder().build());
        KubernetesClient client = this.getClient();
        ReplicationController repl1 = (ReplicationController)((ClientRollableScallableResource)client.replicationControllers().withName("repl1")).get();
        Assert.assertNotNull((Object)repl1);
        repl1 = (ReplicationController)((ClientRollableScallableResource)client.replicationControllers().withName("repl2")).get();
        Assert.assertNull((Object)repl1);
        repl1 = (ReplicationController)((ClientRollableScallableResource)((ClientNonNamespaceOperation)client.replicationControllers().inNamespace("ns1")).withName("repl2")).get();
        Assert.assertNotNull((Object)repl1);
    }

    @Test
    public void testDelete() {
        this.expectAndReturnAsJson("/api/v1/namespaces/test/replicationcontrollers/repl1", 200, ((ReplicationControllerBuilder)((ReplicationControllerFluent.StatusNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName("repl1")).withResourceVersion("1")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).endSpec()).withNewStatus().withReplicas(Integer.valueOf(0))).endStatus()).build());
        this.expectAndReturnAsJson("/api/v1/namespaces/ns1/replicationcontrollers/repl2", 200, ((ReplicationControllerBuilder)((ReplicationControllerFluent.StatusNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName("repl2")).withResourceVersion("1")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).endSpec()).withNewStatus().withReplicas(Integer.valueOf(0))).endStatus()).build());
        KubernetesClient client = this.getClient();
        Boolean deleted = (Boolean)((ClientRollableScallableResource)client.replicationControllers().withName("repl1")).delete();
        Assert.assertNotNull((Object)deleted);
        deleted = (Boolean)((ClientRollableScallableResource)client.replicationControllers().withName("repl2")).delete();
        Assert.assertFalse((boolean)deleted);
        deleted = (Boolean)((ClientRollableScallableResource)((ClientNonNamespaceOperation)client.replicationControllers().inNamespace("ns1")).withName("repl2")).delete();
        Assert.assertTrue((boolean)deleted);
    }

    @Test
    public void testScale() {
        this.expectAndReturnAsJson("/api/v1/namespaces/test/replicationcontrollers/repl1", 200, ((ReplicationControllerBuilder)((ReplicationControllerFluent.StatusNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName("repl1")).withResourceVersion("1")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).endSpec()).withNewStatus().withReplicas(Integer.valueOf(5))).endStatus()).build());
        this.expectAndReturnAsJson("/api/v1/namespaces/ns1/replicationcontrollers/repl2", 200, new ReplicationControllerBuilder().build());
        KubernetesClient client = this.getClient();
        ReplicationController repl = (ReplicationController)((ClientRollableScallableResource)client.replicationControllers().withName("repl1")).scale(5);
        Assert.assertNotNull((Object)repl);
        Assert.assertNotNull((Object)repl.getSpec());
        Assert.assertEquals((long)5L, (long)repl.getSpec().getReplicas().intValue());
    }
}

