/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.acl.SearchGuardACL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AclBuilder {
    private String comment = "[openshift-elasticsearch-plugin]";
    private Set<String> users = new HashSet<String>();
    private Set<String> indexes = new HashSet<String>();
    private Set<String> bypasses = new HashSet<String>();
    private Set<String> executes = new HashSet<String>();

    public SearchGuardACL.Acl build() {
        SearchGuardACL.Acl acl = new SearchGuardACL.Acl();
        acl.setComment(new String(this.comment));
        acl.setIndices(new ArrayList<String>(this.indexes));
        acl.setUsers(new ArrayList<String>(this.users));
        acl.setFiltersBypass(new ArrayList<String>(this.bypasses));
        acl.setFiltersExecute(new ArrayList<String>(this.executes));
        return acl;
    }

    public AclBuilder user(String user) {
        this.users.add(user);
        return this;
    }

    public AclBuilder comment(String comment) {
        this.comment = new String(comment);
        return this;
    }

    public AclBuilder project(String project) {
        this.indexes.add(project);
        return this;
    }

    public AclBuilder bypass(String bypass) {
        this.bypasses.add(bypass);
        return this;
    }

    public AclBuilder executes(String execute) {
        this.executes.add(execute);
        return this;
    }

    public AclBuilder projects(List<String> projects) {
        this.indexes = new HashSet<String>(projects);
        return this;
    }
}

