/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.RunAsUserStrategyOptions;
import io.fabric8.kubernetes.api.model.RunAsUserStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.RunAsUserStrategyOptionsFluent;
import io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptions;
import io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptionsFluent;
import io.fabric8.kubernetes.api.model.SecurityContextConstraints;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SecurityContextConstraintsFluent<T extends SecurityContextConstraintsFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    Boolean allowHostDirVolumePlugin;
    Boolean allowHostNetwork;
    Boolean allowHostPorts;
    Boolean allowPrivilegedContainer;
    List<String> allowedCapabilities = new ArrayList<String>();
    SecurityContextConstraints.ApiVersion apiVersion;
    List<String> groups = new ArrayList<String>();
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<RunAsUserStrategyOptions, ?> runAsUser;
    VisitableBuilder<SELinuxContextStrategyOptions, ?> seLinuxContext;
    List<String> users = new ArrayList<String>();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Boolean isAllowHostDirVolumePlugin() {
        return this.allowHostDirVolumePlugin;
    }

    public T withAllowHostDirVolumePlugin(Boolean allowHostDirVolumePlugin) {
        this.allowHostDirVolumePlugin = allowHostDirVolumePlugin;
        return (T)this;
    }

    public Boolean isAllowHostNetwork() {
        return this.allowHostNetwork;
    }

    public T withAllowHostNetwork(Boolean allowHostNetwork) {
        this.allowHostNetwork = allowHostNetwork;
        return (T)this;
    }

    public Boolean isAllowHostPorts() {
        return this.allowHostPorts;
    }

    public T withAllowHostPorts(Boolean allowHostPorts) {
        this.allowHostPorts = allowHostPorts;
        return (T)this;
    }

    public Boolean isAllowPrivilegedContainer() {
        return this.allowPrivilegedContainer;
    }

    public T withAllowPrivilegedContainer(Boolean allowPrivilegedContainer) {
        this.allowPrivilegedContainer = allowPrivilegedContainer;
        return (T)this;
    }

    public T addToAllowedCapabilities(String ... items) {
        for (String item : items) {
            this.allowedCapabilities.add(item);
        }
        return (T)this;
    }

    public T removeFromAllowedCapabilities(String ... items) {
        for (String item : items) {
            this.allowedCapabilities.remove(item);
        }
        return (T)this;
    }

    public List<String> getAllowedCapabilities() {
        return this.allowedCapabilities;
    }

    public T withAllowedCapabilities(List<String> allowedCapabilities) {
        this.allowedCapabilities.clear();
        if (allowedCapabilities != null) {
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        }
        return (T)this;
    }

    public T withAllowedCapabilities(String ... allowedCapabilities) {
        this.allowedCapabilities.clear();
        if (allowedCapabilities != null) {
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        }
        return (T)this;
    }

    public SecurityContextConstraints.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(SecurityContextConstraints.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public T addToGroups(String ... items) {
        for (String item : items) {
            this.groups.add(item);
        }
        return (T)this;
    }

    public T removeFromGroups(String ... items) {
        for (String item : items) {
            this.groups.remove(item);
        }
        return (T)this;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public T withGroups(List<String> groups) {
        this.groups.clear();
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (T)this;
    }

    public T withGroups(String ... groups) {
        this.groups.clear();
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (T)this;
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public RunAsUserStrategyOptions getRunAsUser() {
        return this.runAsUser != null ? (RunAsUserStrategyOptions)this.runAsUser.build() : null;
    }

    public T withRunAsUser(RunAsUserStrategyOptions runAsUser) {
        if (runAsUser != null) {
            this.runAsUser = new RunAsUserStrategyOptionsBuilder(runAsUser);
            this._visitables.add(this.runAsUser);
        }
        return (T)this;
    }

    public RunAsUserNested<T> withNewRunAsUser() {
        return new RunAsUserNested();
    }

    public RunAsUserNested<T> withNewRunAsUserLike(RunAsUserStrategyOptions item) {
        return new RunAsUserNested(item);
    }

    public RunAsUserNested<T> editRunAsUser() {
        return this.withNewRunAsUserLike(this.getRunAsUser());
    }

    public T withNewRunAsUser(String type, Long uid, Long uidRangeMax, Long uidRangeMin) {
        return this.withRunAsUser(new RunAsUserStrategyOptions(type, uid, uidRangeMax, uidRangeMin));
    }

    public SELinuxContextStrategyOptions getSeLinuxContext() {
        return this.seLinuxContext != null ? (SELinuxContextStrategyOptions)this.seLinuxContext.build() : null;
    }

    public T withSeLinuxContext(SELinuxContextStrategyOptions seLinuxContext) {
        if (seLinuxContext != null) {
            this.seLinuxContext = new SELinuxContextStrategyOptionsBuilder(seLinuxContext);
            this._visitables.add(this.seLinuxContext);
        }
        return (T)this;
    }

    public SeLinuxContextNested<T> withNewSeLinuxContext() {
        return new SeLinuxContextNested();
    }

    public SeLinuxContextNested<T> withNewSeLinuxContextLike(SELinuxContextStrategyOptions item) {
        return new SeLinuxContextNested(item);
    }

    public SeLinuxContextNested<T> editSeLinuxContext() {
        return this.withNewSeLinuxContextLike(this.getSeLinuxContext());
    }

    public T addToUsers(String ... items) {
        for (String item : items) {
            this.users.add(item);
        }
        return (T)this;
    }

    public T removeFromUsers(String ... items) {
        for (String item : items) {
            this.users.remove(item);
        }
        return (T)this;
    }

    public List<String> getUsers() {
        return this.users;
    }

    public T withUsers(List<String> users) {
        this.users.clear();
        if (users != null) {
            for (String item : users) {
                this.addToUsers(item);
            }
        }
        return (T)this;
    }

    public T withUsers(String ... users) {
        this.users.clear();
        if (users != null) {
            for (String item : users) {
                this.addToUsers(item);
            }
        }
        return (T)this;
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityContextConstraintsFluent that = (SecurityContextConstraintsFluent)o;
        if (this.allowHostDirVolumePlugin != null ? !this.allowHostDirVolumePlugin.equals(that.allowHostDirVolumePlugin) : that.allowHostDirVolumePlugin != null) {
            return false;
        }
        if (this.allowHostNetwork != null ? !this.allowHostNetwork.equals(that.allowHostNetwork) : that.allowHostNetwork != null) {
            return false;
        }
        if (this.allowHostPorts != null ? !this.allowHostPorts.equals(that.allowHostPorts) : that.allowHostPorts != null) {
            return false;
        }
        if (this.allowPrivilegedContainer != null ? !this.allowPrivilegedContainer.equals(that.allowPrivilegedContainer) : that.allowPrivilegedContainer != null) {
            return false;
        }
        if (this.allowedCapabilities != null ? !this.allowedCapabilities.equals(that.allowedCapabilities) : that.allowedCapabilities != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.runAsUser != null ? !this.runAsUser.equals(that.runAsUser) : that.runAsUser != null) {
            return false;
        }
        if (this.seLinuxContext != null ? !this.seLinuxContext.equals(that.seLinuxContext) : that.seLinuxContext != null) {
            return false;
        }
        if (this.users != null ? !this.users.equals(that.users) : that.users != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SeLinuxContextNested<N>
    extends SELinuxContextStrategyOptionsFluent<SeLinuxContextNested<N>>
    implements Nested<N> {
        private final SELinuxContextStrategyOptionsBuilder builder;

        SeLinuxContextNested() {
            this.builder = new SELinuxContextStrategyOptionsBuilder(this);
        }

        SeLinuxContextNested(SELinuxContextStrategyOptions item) {
            this.builder = new SELinuxContextStrategyOptionsBuilder(this, item);
        }

        public N endSeLinuxContext() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluent.this.withSeLinuxContext(this.builder.build());
        }
    }

    public class RunAsUserNested<N>
    extends RunAsUserStrategyOptionsFluent<RunAsUserNested<N>>
    implements Nested<N> {
        private final RunAsUserStrategyOptionsBuilder builder;

        RunAsUserNested() {
            this.builder = new RunAsUserStrategyOptionsBuilder(this);
        }

        RunAsUserNested(RunAsUserStrategyOptions item) {
            this.builder = new RunAsUserStrategyOptionsBuilder(this, item);
        }

        public N endRunAsUser() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluent.this.withRunAsUser(this.builder.build());
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNested() {
            this.builder = new ObjectMetaBuilder(this);
        }

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        public N endMetadata() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluent.this.withMetadata(this.builder.build());
        }
    }
}

