/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.elasticsearch.plugin.KibanaUserReindexFilter;
import io.fabric8.elasticsearch.plugin.acl.AclBuilder;
import io.fabric8.elasticsearch.plugin.acl.UserProjectCache;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SearchGuardACL
implements Iterable<Acl> {
    public static final String OPENSHIFT_SYNC = "[openshift-elasticsearch-plugin]";
    public static final String FLUENTD_USER = "system.logging.fluentd";
    public static final String KIBANA_USER = "system.logging.kibana";
    public static final String FLUENTD_EXECUTE_FILTER = "actionrequestfilter.fluentd";
    public static final String KIBANA_EXECUTE_FILTER = "actionrequestfilter.kibana";
    public static final String KIBANA_INDEX = ".kibana.*";
    @JsonProperty(value="acl")
    private List<Acl> acls;

    @Override
    public Iterator<Acl> iterator() {
        return new ArrayList<Acl>(this.acls).iterator();
    }

    public void remove(Acl acl) {
        this.acls.remove(acl);
    }

    public void syncFrom(UserProjectCache cache, String userProfilePrefix) {
        this.removeSyncAcls();
        for (Map.Entry<String, Set<String>> userProjects : cache.getUserProjects().entrySet()) {
            AclBuilder builder = new AclBuilder().user(userProjects.getKey()).bypass("*").projects(this.formatIndicies(userProjects.getKey(), userProjects.getValue(), userProfilePrefix));
            if (cache.isClusterAdmin(userProjects.getKey())) {
                builder.project(".operations.*");
            }
            this.acls.add(builder.build());
        }
    }

    public void createInitialACLs() {
        if (this.acls == null) {
            this.acls = new ArrayList<Acl>();
        }
        Acl defaultAcl = new AclBuilder().comment("Default is to deny all").build();
        this.acls.add(defaultAcl);
        Acl fluentdAcl = new AclBuilder().user(FLUENTD_USER).executes(FLUENTD_EXECUTE_FILTER).comment("Fluentd can only write").build();
        this.acls.add(fluentdAcl);
        Acl kibanaProjectAcl = new AclBuilder().user(KIBANA_USER).project(KIBANA_INDEX).bypass("*").comment("Kibana can do anything in the kibana index").build();
        this.acls.add(kibanaProjectAcl);
        Acl kibanaOthersAcl = new AclBuilder().user(KIBANA_USER).executes(KIBANA_EXECUTE_FILTER).comment("Kibana can only read from every other index").build();
        this.acls.add(kibanaOthersAcl);
    }

    private List<String> formatIndicies(String user, Set<String> projects, String userProfilePrefix) {
        ArrayList<String> indicies = new ArrayList<String>(projects.size());
        indicies.add(String.format("%s.%s", userProfilePrefix, KibanaUserReindexFilter.getUsernameHash(user)));
        for (String project : projects) {
            indicies.add(String.format("%s.*", project));
        }
        return indicies;
    }

    private void removeSyncAcls() {
        for (Acl acl : new ArrayList<Acl>(this.acls)) {
            if (acl.getComment() == null || !acl.getComment().startsWith(OPENSHIFT_SYNC)) continue;
            this.remove(acl);
        }
    }

    public static class Acl {
        @JsonProperty(value="__Comment__")
        private String comment = "";
        @JsonProperty(value="hosts")
        private List<String> hosts = new ArrayList<String>();
        @JsonProperty(value="users")
        private List<String> users = new ArrayList<String>();
        @JsonProperty(value="roles")
        private List<String> roles = new ArrayList<String>();
        @JsonProperty(value="indices")
        private List<String> indices = new ArrayList<String>();
        @JsonProperty(value="aliases")
        private List<String> aliases = new ArrayList<String>();
        @JsonProperty(value="filters_bypass")
        private List<String> filtersBypass = new ArrayList<String>();
        @JsonProperty(value="filters_execute")
        private List<String> filtersExecute = new ArrayList<String>();

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public List<String> getHosts() {
            return this.hosts;
        }

        public void setHosts(List<String> hosts) {
            this.hosts = hosts;
        }

        public List<String> getUsers() {
            return this.users;
        }

        public void setUsers(List<String> users) {
            this.users = users;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public void setRoles(List<String> roles) {
            this.roles = roles;
        }

        public List<String> getIndices() {
            return this.indices;
        }

        public void setIndices(List<String> indicies) {
            this.indices = indicies;
        }

        public List<String> getAliases() {
            return this.aliases;
        }

        public void setAliases(List<String> aliases) {
            this.aliases = aliases;
        }

        public List<String> getFiltersBypass() {
            return this.filtersBypass;
        }

        public void setFiltersBypass(List<String> filterBypass) {
            this.filtersBypass = filterBypass;
        }

        public List<String> getFiltersExecute() {
            return this.filtersExecute;
        }

        public void setFiltersExecute(List<String> filterExecute) {
            this.filtersExecute = filterExecute;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
        }
    }
}

