/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Request;
import com.ning.http.client.Response;
import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.acl.ACLNotifierService;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardACL;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardACLActionRequestListener;
import io.fabric8.elasticsearch.plugin.acl.UserProjectCache;
import io.fabric8.elasticsearch.plugin.kibana.KibanaSeed;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectList;
import io.fabric8.openshift.client.DefaultOpenshiftClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestFilter;
import org.elasticsearch.rest.RestFilterChain;
import org.elasticsearch.rest.RestRequest;

public class DynamicACLFilter
extends RestFilter
implements ConfigurationSettings,
SearchGuardACLActionRequestListener {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String SEARCHGUARD_TYPE = "ac";
    private static final String SEARCHGUARD_ID = "ac";
    private final ObjectMapper mapper = new ObjectMapper();
    private final ESLogger logger;
    private final UserProjectCache cache;
    private final String proxyUserHeader;
    private final Client esClient;
    private final String searchGuardIndex;
    private final String kibanaIndex;
    private final String kibanaVersion;
    private final int aclSyncDelay;
    private final String userProfilePrefix;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition syncing = this.lock.newCondition();
    private Boolean seeded;

    @Inject
    public DynamicACLFilter(UserProjectCache cache, Settings settings, Client client, ACLNotifierService notifierService) {
        this.cache = cache;
        this.logger = Loggers.getLogger(this.getClass(), (Settings)settings, (String[])new String[0]);
        this.esClient = client;
        this.proxyUserHeader = settings.get("searchguard.authentication.proxy.header", "X-Proxy-Remote-User");
        this.searchGuardIndex = settings.get("searchguard.config_index_name", "searchguard");
        this.aclSyncDelay = Integer.valueOf(settings.get("io.fabric8.elasticsearch.acl.sync_delay_millis", String.valueOf(2500)));
        this.userProfilePrefix = settings.get("io.fabric8.elasticsearch.acl.user_profile_prefix", ".kibana");
        this.kibanaIndex = settings.get("kibana.config_index_name", ".kibana");
        this.kibanaVersion = settings.get("kibana.version", "4.1.1");
        notifierService.addActionRequestListener(this);
        this.logger.debug("searchGuardIndex: {}", new Object[]{this.searchGuardIndex});
        this.seeded = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSearchGuardACLActionRequest(String method) {
        this.logger.debug("Received notification that SearchGuard ACL was loaded", new Object[0]);
        this.lock.lock();
        try {
            if (!this.seeded.booleanValue()) {
                try {
                    this.seedInitialACL(this.esClient);
                }
                catch (Exception e) {
                    this.logger.error("Exception encountered when seeding initial ACL", (Throwable)e, new Object[0]);
                }
            }
            this.syncing.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(RestRequest request, RestChannel channel, RestFilterChain chain) throws Exception {
        try {
            String user = this.getUser(request);
            String token = this.getBearerToken(request);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Handling Request...", new Object[0]);
                this.logger.debug("Evaluating request for user '{}' with a {} token", new Object[]{user, StringUtils.isNotEmpty((String)token) ? "non-empty" : "empty"});
                this.logger.debug("Cache has user: {}", new Object[]{this.cache.hasUser(user)});
            }
            if (StringUtils.isNotEmpty((String)token) && StringUtils.isNotEmpty((String)user) && !this.cache.hasUser(user)) {
                boolean isClusterAdmin = this.isClusterAdmin(token);
                if (isClusterAdmin) {
                    request.putInContext((Object)"X-OpenShift-Roles", (Object)"cluster-admin");
                }
                if (this.updateCache(user, token, isClusterAdmin)) {
                    this.syncAcl();
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error handling request in {}", (Throwable)e, new Object[]{this.getClass().getSimpleName()});
        }
        finally {
            chain.continueProcessing(request, channel);
        }
    }

    private String getUser(RestRequest request) {
        return (String)ObjectUtils.defaultIfNull((Object)request.header(this.proxyUserHeader), (Object)"");
    }

    private String getBearerToken(RestRequest request) {
        String[] auth = ((String)ObjectUtils.defaultIfNull((Object)request.header(AUTHORIZATION_HEADER), (Object)"")).split(" ");
        if (auth.length >= 2 && "Bearer".equals(auth[0])) {
            return auth[1];
        }
        return "";
    }

    private boolean updateCache(String user, String token, boolean isClusterAdmin) {
        this.logger.debug("Updating the cache for user '{}'", new Object[]{user});
        try {
            Set<String> projects = this.listProjectsFor(token);
            this.cache.update(user, projects, isClusterAdmin);
            HashSet<String> roles = new HashSet<String>();
            if (isClusterAdmin) {
                roles.add("cluster-admin");
            }
            KibanaSeed.setDashboards(user, projects, roles, this.esClient, this.kibanaIndex, this.kibanaVersion);
        }
        catch (Exception e) {
            this.logger.error("Error retrieving project list for '{}'", (Throwable)e, new Object[]{user});
            return false;
        }
        return true;
    }

    private Set<String> listProjectsFor(String token) throws Exception {
        ConfigBuilder builder = (ConfigBuilder)new ConfigBuilder().withOauthToken(token);
        HashSet<String> names = new HashSet<String>();
        try (DefaultOpenshiftClient client = new DefaultOpenshiftClient((Config)builder.build());){
            List projects = ((ProjectList)client.projects().list()).getItems();
            for (Project project : projects) {
                names.add(project.getMetadata().getName());
            }
        }
        return names;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isClusterAdmin(String token) {
        ConfigBuilder builder = (ConfigBuilder)new ConfigBuilder().withOauthToken(token);
        AsyncHttpClientConfig.Builder clientBuilder = new AsyncHttpClientConfig.Builder().setFollowRedirect(true).setAcceptAnyCertificate(true);
        try (AsyncHttpClient client = new AsyncHttpClient(clientBuilder.build());){
            ObjectMapper mapper = new ObjectMapper();
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("kind", "SubjectAccessReview");
            body.put("apiVersion", "v1");
            body.put("verb", "*");
            body.put("resource", "*");
            String requestBody = mapper.writeValueAsString(body);
            Request request = ((AsyncHttpClient.BoundRequestBuilder)client.preparePost(String.format("%soapi/%s/subjectaccessreviews", builder.getMasterUrl(), builder.getApiVersion())).addHeader(AUTHORIZATION_HEADER, "Bearer " + token).addHeader("Content-Type", "application/json").setBody(requestBody).setContentLength(requestBody.length())).build();
            Response response = (Response)client.executeRequest(request).get();
            this.logger.debug("isAdminResponse {}", new Object[]{response});
            String responseBody = response.getResponseBody();
            this.logger.debug("responseBody: {}", new Object[]{responseBody});
            Map result = (Map)mapper.readValue(responseBody, HashMap.class);
            boolean bl = result.containsKey("allowed") && Boolean.TRUE.equals(result.get("allowed"));
            return bl;
        }
        catch (Exception e) {
            this.logger.error("Exception determining user's role.", (Throwable)e, new Object[0]);
            return false;
        }
    }

    private synchronized void syncAcl() {
        this.logger.debug("Syncing the ACL to ElasticSearch", new Object[0]);
        try {
            this.logger.debug("Loading SearchGuard ACL...", new Object[0]);
            SearchGuardACL acl = this.loadAcl(this.esClient);
            this.logger.debug("Syncing from cache to ACL...", new Object[0]);
            acl.syncFrom(this.cache, this.userProfilePrefix);
            this.write(this.esClient, acl);
        }
        catch (Exception e) {
            this.logger.error("Exception while syncing ACL with cache", (Throwable)e, new Object[0]);
        }
    }

    private SearchGuardACL loadAcl(Client esClient) throws IOException {
        GetRequest request = (GetRequest)esClient.prepareGet(this.searchGuardIndex, "ac", "ac").setRefresh(true).request();
        request.putInContext((Object)"openshift.elasticsearch.request_id", (Object)"openshift.elasticsearch");
        GetResponse response = (GetResponse)esClient.get(request).actionGet();
        return (SearchGuardACL)this.mapper.readValue(response.getSourceAsBytes(), SearchGuardACL.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Client esClient, SearchGuardACL acl) throws JsonProcessingException, InterruptedException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Writing ACLs '{}'", new Object[]{this.mapper.writer((PrettyPrinter)new DefaultPrettyPrinter()).writeValueAsString((Object)acl)});
        }
        UpdateRequest request = (UpdateRequest)esClient.prepareUpdate(this.searchGuardIndex, "ac", "ac").setDoc(this.mapper.writeValueAsBytes((Object)acl)).setRefresh(true).request();
        request.putInContext((Object)"openshift.elasticsearch.request_id", (Object)"openshift.elasticsearch");
        esClient.update(request).actionGet();
        this.lock.lock();
        try {
            this.logger.debug("Waiting up to {} ms. to be notified that SearchGuard has refreshed the ACLs", new Object[]{this.aclSyncDelay});
            this.syncing.await(this.aclSyncDelay, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.logger.error("Error while awaiting notification of ACL load by SearchGuard", (Throwable)e, new Object[0]);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create(Client esClient, SearchGuardACL acl) throws JsonProcessingException, InterruptedException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Writing ACLs '{}'", new Object[]{this.mapper.writer((PrettyPrinter)new DefaultPrettyPrinter()).writeValueAsString((Object)acl)});
        }
        IndexRequest request = (IndexRequest)esClient.prepareIndex(this.searchGuardIndex, "ac", "ac").setSource(this.mapper.writeValueAsBytes((Object)acl)).setRefresh(true).request();
        request.putInContext((Object)"openshift.elasticsearch.request_id", (Object)"openshift.elasticsearch");
        esClient.index(request).actionGet();
        this.lock.lock();
        try {
            this.logger.debug("Waiting up to {} ms. to be notified that SearchGuard has refreshed the ACLs", new Object[]{this.aclSyncDelay});
            this.syncing.await(this.aclSyncDelay, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.logger.error("Error while awaiting notification of ACL load by SearchGuard", (Throwable)e, new Object[0]);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void seedInitialACL(Client esClient) throws Exception {
        SearchGuardACL acl = new SearchGuardACL();
        boolean create = false;
        try {
            acl = this.loadAcl(esClient);
            if (acl.iterator().hasNext()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Have already seeded with '{}'", new Object[]{this.mapper.writer((PrettyPrinter)new DefaultPrettyPrinter()).writeValueAsString((Object)acl)});
                }
                this.seeded = true;
                return;
            }
        }
        catch (NullPointerException | DocumentMissingException | IndexMissingException e) {
            this.logger.debug("Caught Exception, ACL has not been seeded yet", e, new Object[0]);
            create = true;
        }
        catch (Exception e) {
            this.logger.error("Error checking ACL when seeding", (Throwable)e, new Object[0]);
            throw e;
        }
        try {
            acl.createInitialACLs();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Created initial ACL of '{}'", new Object[]{this.mapper.writer((PrettyPrinter)new DefaultPrettyPrinter()).writeValueAsString((Object)acl)});
            }
            if (create) {
                this.create(esClient, acl);
            } else {
                this.write(esClient, acl);
            }
        }
        catch (Exception e) {
            this.logger.error("Error seeding initial ACL", (Throwable)e, new Object[0]);
            throw e;
        }
        this.seeded = true;
    }

    public int order() {
        return Integer.MIN_VALUE;
    }
}

