/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.jdk;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.listenable.AbstractListenableFuture;
import com.ning.http.util.DateUtils;
import java.net.HttpURLConnection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDKFuture<V>
extends AbstractListenableFuture<V> {
    private static final Logger logger = LoggerFactory.getLogger(JDKFuture.class);
    protected Future<V> innerFuture;
    protected final AsyncHandler<V> asyncHandler;
    protected final int responseTimeoutInMs;
    protected final AtomicBoolean cancelled = new AtomicBoolean(false);
    protected final AtomicBoolean timedOut = new AtomicBoolean(false);
    protected final AtomicBoolean isDone = new AtomicBoolean(false);
    protected final AtomicReference<Throwable> exception = new AtomicReference();
    protected final AtomicLong touch = new AtomicLong(DateUtils.millisTime());
    protected final AtomicBoolean contentProcessed = new AtomicBoolean(false);
    protected final HttpURLConnection urlConnection;

    public JDKFuture(AsyncHandler<V> asyncHandler, int responseTimeoutInMs, HttpURLConnection urlConnection) {
        this.asyncHandler = asyncHandler;
        this.responseTimeoutInMs = responseTimeoutInMs;
        this.urlConnection = urlConnection;
    }

    protected void setInnerFuture(Future<V> innerFuture) {
        this.innerFuture = innerFuture;
    }

    @Override
    public void done() {
        this.isDone.set(true);
        this.runListeners();
    }

    @Override
    public void abort(Throwable t) {
        this.exception.set(t);
        if (this.innerFuture != null) {
            this.innerFuture.cancel(true);
        }
        if (!this.timedOut.get() && !this.cancelled.get()) {
            try {
                this.asyncHandler.onThrowable(t);
            }
            catch (Throwable te) {
                logger.debug("asyncHandler.onThrowable", te);
            }
        }
        this.runListeners();
    }

    public void content(V v) {
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!this.cancelled.get() && this.innerFuture != null) {
            this.urlConnection.disconnect();
            try {
                this.asyncHandler.onThrowable(new CancellationException());
            }
            catch (Throwable te) {
                logger.debug("asyncHandler.onThrowable", te);
            }
            this.cancelled.set(true);
            this.runListeners();
            return this.innerFuture.cancel(mayInterruptIfRunning);
        }
        this.runListeners();
        return false;
    }

    @Override
    public boolean isCancelled() {
        if (this.innerFuture != null) {
            return this.innerFuture.isCancelled();
        }
        return false;
    }

    @Override
    public boolean isDone() {
        this.contentProcessed.set(true);
        return this.innerFuture.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get(this.responseTimeoutInMs, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        V content = null;
        try {
            if (this.innerFuture != null) {
                content = this.innerFuture.get(timeout, unit);
            }
        }
        catch (TimeoutException t) {
            if (!this.contentProcessed.get() && timeout != -1L && DateUtils.millisTime() - this.touch.get() <= (long)this.responseTimeoutInMs) {
                return this.get(timeout, unit);
            }
            if (this.exception.get() == null) {
                this.timedOut.set(true);
                throw new ExecutionException(new TimeoutException(String.format("No response received after %s", this.responseTimeoutInMs)));
            }
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        if (this.exception.get() != null) {
            throw new ExecutionException(this.exception.get());
        }
        return content;
    }

    public boolean hasExpired() {
        return this.responseTimeoutInMs != -1 && DateUtils.millisTime() - this.touch.get() > (long)this.responseTimeoutInMs;
    }

    @Override
    public void touch() {
        this.touch.set(DateUtils.millisTime());
    }
}

