/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.acl.ACLNotifierService;
import java.lang.reflect.Method;
import org.apache.commons.lang.ArrayUtils;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class SearchGuardACLRequestActionFilter
extends ActionFilter.Simple
implements ConfigurationSettings {
    private final ACLNotifierService notifier;
    private final String searchGuardIndex;

    @Inject
    protected SearchGuardACLRequestActionFilter(Settings settings, ACLNotifierService notifier) {
        super(settings);
        this.notifier = notifier;
        this.searchGuardIndex = settings.get("searchguard.config_index_name", "searchguard");
    }

    public int order() {
        return Integer.MIN_VALUE;
    }

    protected boolean apply(String action, ActionRequest request, ActionListener listener) {
        GetRequest ir;
        if (request instanceof GetRequest && this.isACLRequest(ir = (GetRequest)request)) {
            this.logger.debug("Received ActionRequest for the SearchGuard ACL with context: '{}'", new Object[]{request.getContext()});
            if (this.isRequestedByUs(ir)) {
                this.logger.debug("SearchGuard ACL being loaded by OpenShift ElasticSearch plugin. Skipping filter", new Object[0]);
                return true;
            }
            this.notifier.notify(action);
        }
        return true;
    }

    private boolean isRequestedByUs(GetRequest request) {
        return "openshift.elasticsearch".equals(request.getFromContext((Object)"openshift.elasticsearch.request_id", (Object)""));
    }

    private boolean isACLRequest(GetRequest request) {
        return ArrayUtils.contains((Object[])request.indices(), (Object)this.searchGuardIndex) && this.includesProperyValue((IndicesRequest)request, "type", "ac") && this.includesProperyValue((IndicesRequest)request, "id", "ac");
    }

    protected boolean apply(String action, ActionResponse response, ActionListener listener) {
        return true;
    }

    private boolean includesProperyValue(IndicesRequest request, String property, String expValue) {
        try {
            Method method = request.getClass().getDeclaredMethod(property, new Class[0]);
            method.setAccessible(true);
            String value = (String)method.invoke((Object)request, new Object[0]);
            return expValue.equals(value);
        }
        catch (Exception e) {
            try {
                Method method = request.getClass().getDeclaredMethod(property + "s", new Class[0]);
                method.setAccessible(true);
                Object[] types = (String[])method.invoke((Object)request, new Object[0]);
                return ArrayUtils.contains((Object[])types, (Object)expValue);
            }
            catch (Exception e1) {
                this.logger.warn("Cannot determine {} for {} due to {}[s]() method not found", new Object[]{property, request, property});
                return false;
            }
        }
    }
}

