/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.acl.ACLNotifierService;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardACLActionRequestListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;

@Singleton
public class DefaultACLNotifierService
implements ACLNotifierService {
    private final Collection<SearchGuardACLActionRequestListener> listeners;
    private ExecutorService notifier;
    private ESLogger logger = Loggers.getLogger(this.getClass());

    @Inject
    public DefaultACLNotifierService(Settings settings) {
        this.listeners = new ConcurrentLinkedQueue<SearchGuardACLActionRequestListener>();
    }

    @Override
    public void notify(final String action) {
        if (this.notifier == null) {
            this.logger.debug("Unable to notify callbacks because notifier thread is null", new Object[0]);
            return;
        }
        this.notifier.execute(new Runnable(){

            @Override
            public void run() {
                DefaultACLNotifierService.this.logger.debug("Notifying {} listeners", new Object[]{DefaultACLNotifierService.this.listeners.size()});
                ArrayList receivers = new ArrayList(DefaultACLNotifierService.this.listeners);
                for (SearchGuardACLActionRequestListener listener : receivers) {
                    try {
                        listener.onSearchGuardACLActionRequest(action);
                    }
                    catch (Exception e) {
                        DefaultACLNotifierService.this.logger.error("There was an exception notifying a listener of a {} action against the SearchGuard ACL", (Throwable)e, new Object[]{action});
                    }
                }
            }
        });
    }

    @Override
    public void addActionRequestListener(SearchGuardACLActionRequestListener listener) {
        this.logger.debug("Added listener: {}", new Object[]{this.listeners.add(listener)});
    }

    @Override
    public void removeActionRequestListener(SearchGuardACLActionRequestListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setExecutorService(ExecutorService service) {
        this.notifier = service;
    }
}

