/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.netty.handler.codec.http.HttpRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.netty.NettyHttpRequest;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestFilter;
import org.elasticsearch.rest.RestFilterChain;
import org.elasticsearch.rest.RestRequest;

public class KibanaUserReindexFilter
extends RestFilter
implements ConfigurationSettings {
    private final ESLogger logger;
    private final String proxyUserHeader;
    private final String kibanaIndex;

    public KibanaUserReindexFilter(Settings settings, ESLogger logger) {
        this.logger = logger;
        this.proxyUserHeader = settings.get("searchguard.authentication.proxy.header", "X-Proxy-Remote-User");
        this.kibanaIndex = settings.get("kibana.config_index_name", "kibana.config_index_name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(RestRequest request, RestChannel channel, RestFilterChain chain) throws Exception {
        try {
            this.logger.debug("Handling Request in Kibana User Reindex filter...", new Object[0]);
            String user = this.getUser(request);
            String requestedIndex = this.getRequestedIndex(request);
            this.logger.debug("Received user '{}' and index '{}', looking for index '{}'", new Object[]{user, requestedIndex, this.kibanaIndex});
            if (StringUtils.isNotEmpty((String)user) && StringUtils.isNotEmpty((String)requestedIndex) && requestedIndex.equalsIgnoreCase(this.kibanaIndex)) {
                String userIndex = requestedIndex + "." + this.getUsernameHash(user);
                this.logger.debug("Matched for a kibana user header, will set to '{}' for user '{}'", new Object[]{userIndex, user});
                request = this.updateRequestIndex(request, requestedIndex, userIndex);
                this.logger.debug("URI for request is '{}' after update", new Object[]{request.uri()});
            }
        }
        catch (Exception e) {
            this.logger.error("Error handling request in OpenShift SearchGuard filter", (Throwable)e, new Object[0]);
        }
        finally {
            chain.continueProcessing(request, channel);
        }
    }

    private String getUser(RestRequest request) {
        return StringUtils.defaultIfBlank((String)request.header(this.proxyUserHeader), (String)"");
    }

    private RestRequest updateRequestIndex(RestRequest request, String oldIndex, String newIndex) {
        String uri = request.uri();
        String replaced = uri.replace(oldIndex, newIndex);
        NettyHttpRequest nettyRequest = (NettyHttpRequest)request;
        HttpRequest httpRequest = nettyRequest.request();
        httpRequest.setUri(replaced);
        return new NettyHttpRequest(httpRequest, nettyRequest.getChannel());
    }

    private String getRequestedIndex(RestRequest request) {
        String uri = StringUtils.defaultIfBlank((String)request.uri(), (String)"");
        String[] splitUri = uri.split("/");
        if (splitUri.length > 0) {
            return uri.split("/")[1];
        }
        return "";
    }

    public int order() {
        return Integer.MAX_VALUE;
    }

    private String getUsernameHash(String username) {
        return DigestUtils.sha1Hex((String)username);
    }
}

