/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.get.GetResult;

public class KibanaUserReindexAction
implements ActionFilter {
    private final ESLogger logger = Loggers.getLogger(KibanaUserReindexAction.class);
    private final String kibanaIndex;

    @Inject
    public KibanaUserReindexAction(Settings settings, ClusterService clusterService, Client client) {
        this.kibanaIndex = settings.get("kibana.config_index_name", "kibana.config_index_name");
        this.logger.debug("Initializing KibanaUserReindexAction", new Object[0]);
    }

    public int order() {
        return Integer.MAX_VALUE;
    }

    public void apply(String action, ActionRequest request, ActionListener listener, ActionFilterChain chain) {
        chain.proceed(action, request, listener);
    }

    public void apply(String action, ActionResponse response, ActionListener listener, ActionFilterChain chain) {
        this.logger.debug("Response with Action '{}' and class '{}'", new Object[]{action, response.getClass()});
        if (response instanceof IndexResponse) {
            IndexResponse ir = (IndexResponse)response;
            String index = this.getIndex((ActionResponse)ir);
            response = new IndexResponse(index, ir.getType(), ir.getId(), ir.getVersion(), ir.isCreated());
        } else if (response instanceof GetResponse) {
            response = new GetResponse(this.buildNewResult((GetResponse)response));
        } else if (response instanceof DeleteResponse) {
            DeleteResponse dr = (DeleteResponse)response;
            String index = this.getIndex((ActionResponse)dr);
            response = new DeleteResponse(index, dr.getType(), dr.getId(), dr.getVersion(), dr.isFound());
        }
        chain.proceed(action, response, listener);
    }

    private GetResult buildNewResult(GetResponse response) {
        String index = this.getIndex((ActionResponse)response);
        GetResult getResult = new GetResult(index, response.getType(), response.getId(), response.getVersion(), response.isExists(), !response.isSourceEmpty() ? response.getSourceAsBytesRef() : null, response.getFields());
        return getResult;
    }

    private boolean isKibanaUserIndex(String index) {
        return index.startsWith(this.kibanaIndex) && !index.equalsIgnoreCase(this.kibanaIndex);
    }

    private String getIndex(ActionResponse response) {
        String index = "";
        if (response instanceof IndexResponse) {
            index = ((IndexResponse)response).getIndex();
        } else if (response instanceof GetResponse) {
            index = ((GetResponse)response).getIndex();
        } else if (response instanceof DeleteResponse) {
            index = ((DeleteResponse)response).getIndex();
        }
        if (this.isKibanaUserIndex(index)) {
            index = this.kibanaIndex;
        }
        return index;
    }
}

