/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.acl.SearchGuardACL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AclBuilder {
    private Set<String> users = new HashSet<String>();
    private Set<String> indexes = new HashSet<String>();

    public SearchGuardACL.Acl build() {
        SearchGuardACL.Acl acl = new SearchGuardACL.Acl();
        acl.setComment("[openshift-elasticsearch-plugin]");
        acl.setIndices(new ArrayList<String>(this.indexes));
        acl.setUsers(new ArrayList<String>(this.users));
        acl.setFiltersBypass(Arrays.asList("*"));
        acl.setFiltersExecute(new ArrayList<String>());
        return acl;
    }

    public AclBuilder user(String user) {
        this.users.add(user);
        return this;
    }

    public AclBuilder project(String project) {
        this.indexes.add(project);
        return this;
    }

    public AclBuilder projects(List<String> projects) {
        this.indexes = new HashSet<String>(projects);
        return this;
    }
}

