/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.netty.buffer.BigEndianHeapChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.handler.codec.http.HttpRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.netty.NettyHttpRequest;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestFilter;
import org.elasticsearch.rest.RestFilterChain;
import org.elasticsearch.rest.RestRequest;

public class KibanaUserReindexFilter
extends RestFilter
implements ConfigurationSettings {
    private final ESLogger logger;
    private final String proxyUserHeader;
    private final String kibanaIndex;

    public KibanaUserReindexFilter(Settings settings, ESLogger logger) {
        this.logger = logger;
        this.proxyUserHeader = settings.get("searchguard.authentication.proxy.header", "X-Proxy-Remote-User");
        this.kibanaIndex = settings.get("kibana.config_index_name", ".kibana");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(RestRequest request, RestChannel channel, RestFilterChain chain) throws Exception {
        try {
            this.logger.debug("Handling Request in Kibana User Reindex filter...", new Object[0]);
            String user = this.getUser(request);
            String requestedIndex = this.getRequestedIndex(request);
            this.logger.debug("Received user '{}' and index '{}', checking for kibana index '{}'", new Object[]{user, requestedIndex, this.kibanaIndex});
            if (StringUtils.isNotEmpty((String)user) && StringUtils.isNotEmpty((String)requestedIndex) && requestedIndex.equalsIgnoreCase(this.kibanaIndex)) {
                String userIndex = requestedIndex + "." + KibanaUserReindexFilter.getUsernameHash(user);
                this.logger.debug("Matched for a kibana user header, will set to '{}' for user '{}'", new Object[]{userIndex, user});
                request = this.updateRequestIndex(request, requestedIndex, userIndex);
                this.logger.debug("URI for request is '{}' after update", new Object[]{request.uri()});
            } else if (StringUtils.isNotEmpty((String)user) && StringUtils.isNotEmpty((String)requestedIndex) && requestedIndex.startsWith("_mget")) {
                String userIndex = ".kibana." + KibanaUserReindexFilter.getUsernameHash(user);
                this.logger.debug("Matched for a kibana user header, will set to '{}' for user '{}'", new Object[]{userIndex, user});
                request = this.updateMGetRequest(request, ".kibana", userIndex);
                this.logger.debug("URI for request is '{}' after update", new Object[]{request.uri()});
            }
        }
        catch (Exception e) {
            this.logger.error("Error handling request in OpenShift SearchGuard filter", (Throwable)e, new Object[0]);
        }
        finally {
            chain.continueProcessing(request, channel);
        }
    }

    private String getUser(RestRequest request) {
        return StringUtils.defaultIfBlank((String)request.header(this.proxyUserHeader), (String)"");
    }

    private RestRequest updateMGetRequest(RestRequest request, String oldIndex, String newIndex) {
        BytesReference content = request.content();
        String stringContent = content.toUtf8();
        this.logger.debug("Received MGet request '{}' with content '{}'", new Object[]{request, stringContent});
        String replaced = stringContent.replaceAll("_index\":\"" + oldIndex + "\"", "_index\":\"" + newIndex + "\"");
        NettyHttpRequest nettyRequest = (NettyHttpRequest)request;
        HttpRequest httpRequest = nettyRequest.request();
        BytesArray replacedContent = new BytesArray(replaced);
        BigEndianHeapChannelBuffer buffer = new BigEndianHeapChannelBuffer(replacedContent.array());
        httpRequest.setContent((ChannelBuffer)buffer);
        return new NettyHttpRequest(httpRequest, nettyRequest.getChannel());
    }

    private RestRequest updateRequestIndex(RestRequest request, String oldIndex, String newIndex) {
        String uri = request.uri();
        String replaced = uri.replace(oldIndex, newIndex);
        NettyHttpRequest nettyRequest = (NettyHttpRequest)request;
        HttpRequest httpRequest = nettyRequest.request();
        httpRequest.setUri(replaced);
        return new NettyHttpRequest(httpRequest, nettyRequest.getChannel());
    }

    private String getRequestedIndex(RestRequest request) {
        String uri = StringUtils.defaultIfBlank((String)request.uri(), (String)"");
        String[] splitUri = uri.split("/");
        if (splitUri.length > 0) {
            return uri.split("/")[1];
        }
        return "";
    }

    public int order() {
        return Integer.MAX_VALUE;
    }

    public static String getUsernameHash(String username) {
        return DigestUtils.sha1Hex((String)username);
    }
}

