/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.kibana;

import io.fabric8.elasticsearch.plugin.KibanaUserReindexFilter;
import io.fabric8.elasticsearch.plugin.kibana.DocumentBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.search.SearchHit;

public class KibanaSeed {
    private static ESLogger logger = Loggers.getLogger(KibanaSeed.class);
    private static final String DEFAULT_INDEX_TYPE = "config";
    private static final String INDICIES_TYPE = "index-pattern";
    private static final String OPERATIONS_PROJECT = ".operations";
    private static final String BLANK_PROJECT = ".empty-project";
    private static final String ADMIN_ALIAS_NAME = ".all";
    private static final String[] OPERATIONS_ROLES = new String[]{"cluster-admin"};
    public static final String DEFAULT_INDEX_FIELD = "defaultIndex";

    public static void setDashboards(String user, Set<String> projects, Set<String> roles, Client esClient, String kibanaIndex, String kibanaVersion) {
        boolean isAdmin = false;
        Set<String> indexPatterns = KibanaSeed.getIndexPatterns(user, esClient, kibanaIndex);
        logger.debug("Found '{}' Index patterns for user", new Object[]{indexPatterns.size()});
        logger.debug("Checking for '{}' in users roles '{}'", new Object[]{OPERATIONS_ROLES, roles});
        for (String role : OPERATIONS_ROLES) {
            if (!roles.contains(role)) continue;
            logger.debug("{} is an admin user", new Object[]{user});
            projects.add(OPERATIONS_PROJECT);
            isAdmin = true;
            projects.add(ADMIN_ALIAS_NAME);
            break;
        }
        ArrayList<String> sortedProjects = new ArrayList<String>(projects);
        Collections.sort(sortedProjects);
        if (sortedProjects.isEmpty()) {
            sortedProjects.add(BLANK_PROJECT);
        }
        logger.debug("Setting dashboards given user '{}' and projects '{}'", new Object[]{user, projects});
        if (isAdmin) {
            logger.debug("Adding to alias for {}", new Object[]{user});
            KibanaSeed.buildAdminAlias(user, sortedProjects, esClient, kibanaIndex, kibanaVersion);
        }
        if (indexPatterns.isEmpty()) {
            KibanaSeed.create(user, sortedProjects, true, esClient, kibanaIndex, kibanaVersion);
        } else {
            ArrayList<String> common = new ArrayList<String>(indexPatterns);
            common.retainAll(sortedProjects);
            sortedProjects.removeAll(common);
            indexPatterns.removeAll(common);
            if (!isAdmin) {
                logger.debug("user is not a cluster admin, ensure they don't keep/have the admin alias pattern", new Object[0]);
                indexPatterns.add(ADMIN_ALIAS_NAME);
            }
            KibanaSeed.create(user, sortedProjects, false, esClient, kibanaIndex, kibanaVersion);
            KibanaSeed.remove(user, indexPatterns, esClient, kibanaIndex);
            common.addAll(sortedProjects);
            Collections.sort(common);
            String defaultIndex = KibanaSeed.getDefaultIndex(user, esClient, kibanaIndex, kibanaVersion);
            logger.debug("Checking if '{}' contains '{}'", new Object[]{indexPatterns, defaultIndex});
            if (indexPatterns.contains(defaultIndex) || StringUtils.isEmpty((String)defaultIndex)) {
                logger.debug("'{}' does contain '{}' and common size is {}", new Object[]{indexPatterns, defaultIndex, common.size()});
                if (common.size() > 0) {
                    KibanaSeed.setDefaultIndex(user, (String)common.get(0), esClient, kibanaIndex, kibanaVersion);
                }
            }
        }
    }

    private static void setDefaultIndex(String username, String project, Client esClient, String kibanaIndex, String kibanaVersion) {
        String source = new DocumentBuilder().defaultIndex(KibanaSeed.getIndexPattern(project)).build();
        KibanaSeed.executeCreate(KibanaSeed.getKibanaIndex(username, kibanaIndex), DEFAULT_INDEX_TYPE, kibanaVersion, source, esClient);
    }

    private static void buildAdminAlias(String username, List<String> projects, Client esClient, String kibanaIndex, String kibanaVersion) {
        ArrayList<String> toAdd = new ArrayList<String>(projects);
        try {
            for (String project : projects) {
                IndicesExistsResponse existsResponse = (IndicesExistsResponse)esClient.admin().indices().prepareExists(new String[]{KibanaSeed.getIndexPattern(project)}).get();
                logger.debug("Checking if index {} exists? {}", new Object[]{project, existsResponse.isExists()});
                if (existsResponse.isExists() && !project.equalsIgnoreCase(ADMIN_ALIAS_NAME)) continue;
                toAdd.remove(project);
            }
            if (toAdd.isEmpty()) {
                return;
            }
            IndicesAliasesRequestBuilder aliasBuilder = esClient.admin().indices().prepareAliases();
            for (String project : toAdd) {
                logger.debug("Creating alias for {} as {}", new Object[]{project, ADMIN_ALIAS_NAME});
                aliasBuilder.addAlias(KibanaSeed.getIndexPattern(project), ADMIN_ALIAS_NAME);
            }
            IndicesAliasesResponse response = (IndicesAliasesResponse)aliasBuilder.get();
            logger.debug("Aliases request acknowledged? {}", new Object[]{response.isAcknowledged()});
        }
        catch (ElasticsearchException e) {
            logger.error("Error executing Alias request", (Throwable)e, new Object[0]);
        }
    }

    private static String getDefaultIndex(String username, Client esClient, String kibanaIndex, String kibanaVersion) {
        GetRequest request = (GetRequest)esClient.prepareGet(KibanaSeed.getKibanaIndex(username, kibanaIndex), DEFAULT_INDEX_TYPE, kibanaVersion).request();
        try {
            GetResponse response = (GetResponse)esClient.get(request).get();
            Map source = response.getSource();
            if (source != null && source.containsKey(DEFAULT_INDEX_FIELD)) {
                logger.debug("Received response with 'defaultIndex' = {}", new Object[]{source.get(DEFAULT_INDEX_FIELD)});
                String index = (String)source.get(DEFAULT_INDEX_FIELD);
                return KibanaSeed.getProjectFromIndex(index);
            }
            logger.debug("Received response without 'defaultIndex'", new Object[0]);
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() instanceof IndexMissingException) {
                logger.debug("No index found", new Object[0]);
            }
            logger.error("Error getting default index for {}", (Throwable)e, new Object[]{username});
        }
        return "";
    }

    private static void create(String user, List<String> projects, boolean setDefault, Client esClient, String kibanaIndex, String kibanaVersion) {
        boolean defaultSet = !setDefault;
        for (String project : projects) {
            KibanaSeed.createIndex(user, project, esClient, kibanaIndex);
            if (defaultSet) continue;
            KibanaSeed.setDefaultIndex(user, project, esClient, kibanaIndex, kibanaVersion);
            defaultSet = true;
        }
    }

    private static void remove(String user, Set<String> projects, Client esClient, String kibanaIndex) {
        for (String project : projects) {
            KibanaSeed.deleteIndex(user, project, esClient, kibanaIndex);
        }
    }

    private static Set<String> getIndexPatterns(String username, Client esClient, String kibanaIndex) {
        HashSet<String> patterns = new HashSet<String>();
        SearchRequest request = esClient.prepareSearch(new String[]{KibanaSeed.getKibanaIndex(username, kibanaIndex)}).setTypes(new String[]{INDICIES_TYPE}).request();
        try {
            SearchResponse response = (SearchResponse)esClient.search(request).get();
            if (response.getHits() != null && response.getHits().getTotalHits() > 0L) {
                for (SearchHit hit : response.getHits().getHits()) {
                    String id = hit.getId();
                    String project = KibanaSeed.getProjectFromIndex(id);
                    if (project.equals(id)) continue;
                    patterns.add(project);
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() instanceof IndexMissingException) {
                logger.debug("Encountered IndexMissingException, returning empty response", new Object[0]);
            }
            logger.error("Error getting index patterns for {}", (Throwable)e, new Object[]{username});
        }
        return patterns;
    }

    private static void createIndex(String username, String project, Client esClient, String kibanaIndex) {
        DocumentBuilder sourceBuilder = new DocumentBuilder().title(KibanaSeed.getIndexPattern(project)).timeFieldName("time");
        if (project.equalsIgnoreCase(OPERATIONS_PROJECT) || project.equalsIgnoreCase(ADMIN_ALIAS_NAME)) {
            sourceBuilder.operationsFields();
        } else if (project.equalsIgnoreCase(BLANK_PROJECT)) {
            sourceBuilder.blankFields();
        } else {
            sourceBuilder.applicationFields();
        }
        String source = sourceBuilder.build();
        KibanaSeed.executeCreate(KibanaSeed.getKibanaIndex(username, kibanaIndex), INDICIES_TYPE, KibanaSeed.getIndexPattern(project), source, esClient);
    }

    private static void deleteIndex(String username, String project, Client esClient, String kibanaIndex) {
        KibanaSeed.executeDelete(KibanaSeed.getKibanaIndex(username, kibanaIndex), INDICIES_TYPE, KibanaSeed.getIndexPattern(project), esClient);
    }

    private static void executeCreate(String index, String type, String id, String source, Client esClient) {
        logger.debug("CREATE: '{}/{}/{}' source: '{}'", new Object[]{index, type, id, source});
        IndexRequest request = (IndexRequest)esClient.prepareIndex(index, type, id).setSource(source).request();
        try {
            esClient.index(request).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Error executing create request", (Throwable)e, new Object[0]);
        }
    }

    private static void executeDelete(String index, String type, String id, Client esClient) {
        logger.debug("DELETE: '{}/{}/{}'", new Object[]{index, type, id});
        DeleteRequest request = (DeleteRequest)esClient.prepareDelete(index, type, id).request();
        try {
            esClient.delete(request).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Error executing delete request", (Throwable)e, new Object[0]);
        }
    }

    private static String getKibanaIndex(String username, String kibanaIndex) {
        return kibanaIndex + "." + KibanaUserReindexFilter.getUsernameHash(username);
    }

    private static String getIndexPattern(String project) {
        if (project.equalsIgnoreCase(ADMIN_ALIAS_NAME)) {
            return project;
        }
        return project + ".*";
    }

    private static String getProjectFromIndex(String index) {
        if (!StringUtils.isEmpty((String)index)) {
            if (index.equalsIgnoreCase(ADMIN_ALIAS_NAME)) {
                return index;
            }
            int wildcard = index.lastIndexOf(46);
            if (wildcard > 0) {
                return index.substring(0, wildcard);
            }
        }
        return index;
    }
}

