/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin;

import com.floragunn.searchguard.authentication.AuthException;
import com.floragunn.searchguard.authentication.User;
import com.floragunn.searchguard.authentication.backend.AuthenticationBackend;
import com.floragunn.searchguard.authentication.http.HTTPAuthenticator;
import com.floragunn.searchguard.authentication.http.clientcert.HTTPSClientCertAuthenticator;
import com.floragunn.searchguard.authentication.http.proxy.HTTPProxyAuthenticator;
import com.floragunn.searchguard.authorization.Authorizator;
import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.UnauthorizedException;
import org.apache.commons.lang.ArrayUtils;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;

public class HTTPSProxyClientCertAuthenticator
implements HTTPAuthenticator,
ConfigurationSettings {
    private final HTTPProxyAuthenticator proxyAuthenticator;
    private final HTTPSClientCertAuthenticator certAuthenticator;
    private final String[] userWhitelists;
    private final ESLogger log;

    @Inject
    public HTTPSProxyClientCertAuthenticator(Settings settings) {
        this(settings, new HTTPProxyAuthenticator(settings), new HTTPSClientCertAuthenticator(settings), Loggers.getLogger(HTTPSProxyClientCertAuthenticator.class));
    }

    public HTTPSProxyClientCertAuthenticator(Settings settings, HTTPProxyAuthenticator proxyAuthenticator, HTTPSClientCertAuthenticator certAuthenticator, ESLogger logger) {
        this.certAuthenticator = certAuthenticator;
        this.proxyAuthenticator = proxyAuthenticator;
        this.userWhitelists = settings.getAsArray("io.fabric8.elasticsearch.authentication.users", DEFAULT_WHITELISTED_USERS);
        this.log = logger;
    }

    public User authenticate(RestRequest request, RestChannel channel, AuthenticationBackend backend, Authorizator authorizator) throws AuthException {
        User user = null;
        try {
            user = this.proxyAuthenticator.authenticate(request, channel, backend, authorizator);
        }
        catch (AuthException e) {
            this.log.debug("Unable to Authenticate using the proxy header.  Trying certificate authorization...", new Object[0]);
        }
        if (user != null) {
            if (ArrayUtils.contains((Object[])this.userWhitelists, (Object)user.getName())) {
                this.log.info("Denying a request because it has a proxy user header that is the same as one that is whitelisted", new Object[0]);
                throw new AuthException("Denying a request because it has a proxy userheader that is the same as one that is whitelisted.");
            }
            return user;
        }
        try {
            return this.certAuthenticator.authenticate(request, channel, backend, authorizator);
        }
        catch (AuthException e) {
            throw new UnauthorizedException(e);
        }
    }
}

