/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin;

import io.fabric8.elasticsearch.plugin.ForbiddenException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;

public class ActionForbiddenActionFilter
implements ActionFilter {
    private ESLogger logger = Loggers.getLogger(this.getClass());

    @Inject
    public ActionForbiddenActionFilter() {
    }

    public int order() {
        return Integer.MIN_VALUE;
    }

    public void apply(String action, ActionRequest request, final ActionListener listener, ActionFilterChain chain) {
        chain.proceed(action, request, new ActionListener(){

            public void onResponse(Object response) {
                listener.onResponse(response);
            }

            public void onFailure(Throwable e) {
                if (e.getMessage().contains("is forbidden due to")) {
                    ActionForbiddenActionFilter.this.logger.debug("SearchGuard 403", e, new Object[0]);
                    listener.onFailure((Throwable)((Object)new ForbiddenException(e)));
                } else {
                    listener.onFailure(e);
                }
            }
        });
    }

    public void apply(String action, ActionResponse response, ActionListener listener, ActionFilterChain chain) {
        chain.proceed(action, response, listener);
    }
}

