/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.get.GetField;
import org.elasticsearch.index.get.GetResult;

public class KibanaUserReindexAction
implements ActionFilter,
ConfigurationSettings {
    private final ESLogger logger = Loggers.getLogger(KibanaUserReindexAction.class);
    private final String kibanaIndex;

    @Inject
    public KibanaUserReindexAction(Settings settings, ClusterService clusterService, Client client) {
        this.kibanaIndex = settings.get("kibana.config_index_name", ".kibana");
        this.logger.debug("Initializing KibanaUserReindexAction", new Object[0]);
    }

    public int order() {
        return Integer.MAX_VALUE;
    }

    public void apply(String action, ActionRequest request, ActionListener listener, ActionFilterChain chain) {
        chain.proceed(action, request, listener);
    }

    public void apply(String action, ActionResponse response, ActionListener listener, ActionFilterChain chain) {
        this.logger.debug("Response with Action '{}' and class '{}'", new Object[]{action, response.getClass()});
        if (this.containsKibanaUserIndex(response)) {
            if (response instanceof IndexResponse) {
                IndexResponse ir = (IndexResponse)response;
                String index = this.getIndex((ActionResponse)ir);
                response = new IndexResponse(index, ir.getType(), ir.getId(), ir.getVersion(), ir.isCreated());
            } else if (response instanceof GetResponse) {
                response = new GetResponse(this.buildNewResult((GetResponse)response));
            } else if (response instanceof DeleteResponse) {
                DeleteResponse dr = (DeleteResponse)response;
                String index = this.getIndex((ActionResponse)dr);
                response = new DeleteResponse(index, dr.getType(), dr.getId(), dr.getVersion(), dr.isFound());
            } else if (response instanceof MultiGetResponse) {
                MultiGetResponse mgr = (MultiGetResponse)response;
                MultiGetItemResponse[] responses = new MultiGetItemResponse[mgr.getResponses().length];
                int index = 0;
                for (MultiGetItemResponse item : mgr.getResponses()) {
                    GetResponse itemResponse = item.getResponse();
                    MultiGetResponse.Failure itemFailure = item.getFailure();
                    GetResponse getResponse = itemResponse != null ? new GetResponse(this.buildNewResult(itemResponse)) : null;
                    MultiGetResponse.Failure failure = itemFailure != null ? this.buildNewFailure(itemFailure) : null;
                    responses[index] = new MultiGetItemResponse(getResponse, failure);
                    ++index;
                }
                response = new MultiGetResponse(responses);
            } else if (response instanceof GetFieldMappingsResponse) {
                GetFieldMappingsResponse gfmResponse = (GetFieldMappingsResponse)response;
                ImmutableMap mappings = gfmResponse.mappings();
                String index = "";
                for (String key : mappings.keySet()) {
                    index = key;
                    if (!this.isKibanaUserIndex(index)) continue;
                    index = this.kibanaIndex;
                }
                BytesStreamOutput bso = new BytesStreamOutput();
                try {
                    MappingResponseRemapper remapper = new MappingResponseRemapper();
                    remapper.updateMappingResponse((StreamOutput)bso, index, (ImmutableMap<String, ImmutableMap<String, ImmutableMap<String, GetFieldMappingsResponse.FieldMappingMetaData>>>)mappings);
                    BytesStreamInput input = new BytesStreamInput(bso.bytes());
                    response.readFrom((StreamInput)input);
                }
                catch (IOException e) {
                    this.logger.error("Error while rewriting GetFieldMappingsResponse", (Throwable)e, new Object[0]);
                }
            }
        }
        chain.proceed(action, response, listener);
    }

    private GetResult buildNewResult(GetResponse response) {
        String index = this.getIndex((ActionResponse)response);
        String replacedIndex = response.getIndex();
        BytesArray replacedContent = null;
        if (!response.isSourceEmpty()) {
            String source = response.getSourceAsBytesRef().toUtf8();
            String replaced = source.replaceAll(replacedIndex, index);
            replacedContent = new BytesArray(replaced);
        }
        Map responseFields = response.getFields();
        for (String key : responseFields.keySet()) {
            GetField replacedField = (GetField)responseFields.get(key);
            for (Object o : replacedField.getValues()) {
                String value;
                if (!(o instanceof String) || !(value = (String)o).contains(replacedIndex)) continue;
                replacedField.getValues().remove(o);
                replacedField.getValues().add(value.replaceAll(replacedIndex, index));
            }
        }
        GetResult getResult = new GetResult(index, response.getType(), response.getId(), response.getVersion(), response.isExists(), (BytesReference)replacedContent, response.getFields());
        return getResult;
    }

    private MultiGetResponse.Failure buildNewFailure(MultiGetResponse.Failure failure) {
        String index = failure.getIndex();
        String message = failure.getMessage();
        if (this.isKibanaUserIndex(index)) {
            message = message.replace(index, this.kibanaIndex);
            index = this.kibanaIndex;
        }
        return new MultiGetResponse.Failure(index, failure.getType(), failure.getId(), message);
    }

    private boolean isKibanaUserIndex(String index) {
        return index.startsWith(this.kibanaIndex) && !index.equalsIgnoreCase(this.kibanaIndex);
    }

    private String getIndex(ActionResponse response) {
        String index = "";
        if (response instanceof IndexResponse) {
            index = ((IndexResponse)response).getIndex();
        } else if (response instanceof GetResponse) {
            index = ((GetResponse)response).getIndex();
        } else if (response instanceof DeleteResponse) {
            index = ((DeleteResponse)response).getIndex();
        }
        if (this.isKibanaUserIndex(index)) {
            index = this.kibanaIndex;
        }
        return index;
    }

    private boolean containsKibanaUserIndex(ActionResponse response) {
        String index = "";
        if (response instanceof MultiGetResponse) {
            for (MultiGetItemResponse item : ((MultiGetResponse)response).getResponses()) {
                GetResponse itemResponse = item.getResponse();
                MultiGetResponse.Failure itemFailure = item.getFailure();
                if (!(itemResponse == null ? this.isKibanaUserIndex(itemFailure.getIndex()) : this.isKibanaUserIndex(itemResponse.getIndex()))) continue;
                return true;
            }
            return false;
        }
        if (response instanceof IndexResponse) {
            index = ((IndexResponse)response).getIndex();
        } else if (response instanceof GetResponse) {
            index = ((GetResponse)response).getIndex();
        } else if (response instanceof DeleteResponse) {
            index = ((DeleteResponse)response).getIndex();
        } else if (response instanceof GetFieldMappingsResponse) {
            ImmutableMap mappings = ((GetFieldMappingsResponse)response).mappings();
            Iterator i$ = mappings.keySet().iterator();
            while (i$.hasNext()) {
                String key;
                index = key = (String)i$.next();
            }
        }
        return this.isKibanaUserIndex(index);
    }

    private static class MappingResponseRemapper
    extends ActionResponse
    implements ToXContent {
        ESLogger logger = Loggers.getLogger(MappingResponseRemapper.class);

        private MappingResponseRemapper() {
        }

        public void updateMappingResponse(StreamOutput out, String index, ImmutableMap<String, ImmutableMap<String, ImmutableMap<String, GetFieldMappingsResponse.FieldMappingMetaData>>> mappings) throws IOException {
            super.writeTo(out);
            out.writeVInt(mappings.size());
            for (Map.Entry indexEntry : mappings.entrySet()) {
                out.writeString(index);
                out.writeVInt(((ImmutableMap)indexEntry.getValue()).size());
                for (Map.Entry typeEntry : ((ImmutableMap)indexEntry.getValue()).entrySet()) {
                    out.writeString((String)typeEntry.getKey());
                    out.writeVInt(((ImmutableMap)typeEntry.getValue()).size());
                    for (Map.Entry fieldEntry : ((ImmutableMap)typeEntry.getValue()).entrySet()) {
                        out.writeString((String)fieldEntry.getKey());
                        GetFieldMappingsResponse.FieldMappingMetaData fieldMapping = (GetFieldMappingsResponse.FieldMappingMetaData)fieldEntry.getValue();
                        out.writeString(fieldMapping.fullName());
                        Map map = fieldMapping.sourceAsMap();
                        XContentBuilder builder = XContentBuilder.builder((XContent)JsonXContent.jsonXContent);
                        builder.map(map).close();
                        out.writeBytesReference(builder.bytes());
                    }
                }
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return null;
        }
    }
}

