/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.acl.UserProjectCache;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.elasticsearch.common.logging.ESLogger;

public class UserProjectCacheMapAdapter
implements UserProjectCache {
    private final ESLogger logger;
    private final Map<String, Set<String>> cache = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Long> createTimes = new ConcurrentHashMap<String, Long>();
    private static final long EXPIRE = 60000L;

    public UserProjectCacheMapAdapter(ESLogger logger) {
        this.logger = logger;
    }

    @Override
    public Map<String, Set<String>> getUserProjects() {
        return Collections.unmodifiableMap(this.cache);
    }

    @Override
    public boolean hasUser(String user) {
        return this.cache.containsKey(user);
    }

    @Override
    public void update(String user, Set<String> projects) {
        this.cache.put(user, new HashSet<String>(projects));
        this.createTimes.put(user, System.currentTimeMillis() + 60000L);
    }

    @Override
    public void expire() {
        long now = System.currentTimeMillis();
        for (Map.Entry<String, Long> entry : new HashSet<Map.Entry<String, Long>>(this.createTimes.entrySet())) {
            if (now <= entry.getValue()) continue;
            this.logger.debug("Expiring cache entry for {}", new Object[]{entry.getKey()});
            this.cache.remove(entry.getKey());
            this.createTimes.remove(entry.getKey());
        }
    }
}

