/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardACL;
import io.fabric8.elasticsearch.plugin.acl.UserProjectCache;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectList;
import io.fabric8.openshift.client.DefaultOpenshiftClient;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestFilter;
import org.elasticsearch.rest.RestFilterChain;
import org.elasticsearch.rest.RestRequest;

public class DynamicACLFilter
extends RestFilter
implements ConfigurationSettings {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String SEARCHGUARD_TYPE = "ac";
    private static final String SEARCHGUARD_ID = "ac";
    private final ObjectMapper mapper = new ObjectMapper();
    private final ESLogger logger;
    private final UserProjectCache cache;
    private final String proxyUserHeader;
    private final Client esClient;
    private final String searchGuardIndex;
    private final int aclSyncDelay;
    private final String userProfilePrefix;

    public DynamicACLFilter(UserProjectCache cache, Settings settings, Client client, ESLogger logger) {
        this.cache = cache;
        this.logger = logger;
        this.esClient = client;
        this.proxyUserHeader = settings.get("searchguard.authentication.proxy.header", "X-Authenticated-User");
        this.searchGuardIndex = settings.get("searchguard.config_index_name", "searchguard");
        this.aclSyncDelay = Integer.valueOf(settings.get("io.fabric8.elasticsearch.acl.sync_delay_millis", String.valueOf(2500)));
        this.userProfilePrefix = settings.get("io.fabric8.elasticsearch.acl.user_profile_prefix", ".kibana");
        logger.debug("searchGuardIndex: {}", new Object[]{this.searchGuardIndex});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(RestRequest request, RestChannel channel, RestFilterChain chain) throws Exception {
        try {
            this.logger.debug("Handling Request in {}...", new Object[]{this.getClass().getSimpleName()});
            String user = this.getUser(request);
            String token = this.getBearerToken(request);
            this.logger.debug("Evaluating request for user '{}' with a {} token", new Object[]{user, StringUtils.isNotEmpty((String)token) ? "non-empty" : "empty"});
            this.logger.debug("Cache has user: {}", new Object[]{this.cache.hasUser(user)});
            if (StringUtils.isNotEmpty((String)token) && StringUtils.isNotEmpty((String)user) && !this.cache.hasUser(user) && this.updateCache(user, token)) {
                this.syncAcl();
            }
        }
        catch (Exception e) {
            this.logger.error("Error handling request in {}", (Throwable)e, new Object[]{this.getClass().getSimpleName()});
        }
        finally {
            chain.continueProcessing(request, channel);
        }
    }

    private String getUser(RestRequest request) {
        return (String)ObjectUtils.defaultIfNull((Object)request.header(this.proxyUserHeader), (Object)"");
    }

    private String getBearerToken(RestRequest request) {
        String[] auth = ((String)ObjectUtils.defaultIfNull((Object)request.header(AUTHORIZATION_HEADER), (Object)"")).split(" ");
        if (auth.length >= 2 && "Bearer".equals(auth[0])) {
            return auth[1];
        }
        return "";
    }

    private boolean updateCache(String user, String token) {
        this.logger.debug("Updating the cache for user '{}'", new Object[]{user});
        try {
            Set<String> projects = this.listProjectsFor(token);
            this.cache.update(user, projects);
        }
        catch (Exception e) {
            this.logger.error("Error retrieving project list for '{}'", (Throwable)e, new Object[]{user});
            return false;
        }
        return true;
    }

    private Set<String> listProjectsFor(String token) throws Exception {
        ConfigBuilder builder = (ConfigBuilder)new ConfigBuilder().withOauthToken(token);
        HashSet<String> names = new HashSet<String>();
        try (DefaultOpenshiftClient client = new DefaultOpenshiftClient((Config)builder.build());){
            List projects = ((ProjectList)client.projects().list()).getItems();
            for (Project project : projects) {
                names.add(project.getMetadata().getName());
            }
        }
        return names;
    }

    private synchronized void syncAcl() {
        this.logger.debug("Syncing the ACL to ElasticSearch", new Object[0]);
        try {
            this.logger.debug("Loading SearchGuard ACL...", new Object[0]);
            SearchGuardACL acl = this.loadAcl(this.esClient);
            this.logger.debug("Syncing from cache to ACL...", new Object[0]);
            acl.syncFrom(this.cache, this.userProfilePrefix);
            this.write(this.esClient, acl);
        }
        catch (Exception e) {
            this.logger.error("Exception while syncing ACL with cache", (Throwable)e, new Object[0]);
        }
    }

    private SearchGuardACL loadAcl(Client esClient) throws IOException {
        GetResponse response = (GetResponse)esClient.prepareGet(this.searchGuardIndex, "ac", "ac").setRefresh(true).execute().actionGet();
        return (SearchGuardACL)this.mapper.readValue(response.getSourceAsBytes(), SearchGuardACL.class);
    }

    private void write(Client esClient, SearchGuardACL acl) throws JsonProcessingException, InterruptedException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Writing ACLs '{}'", new Object[]{this.mapper.writer((PrettyPrinter)new DefaultPrettyPrinter()).writeValueAsString((Object)acl)});
        }
        esClient.prepareUpdate(this.searchGuardIndex, "ac", "ac").setDoc(this.mapper.writeValueAsBytes((Object)acl)).setRefresh(true).execute();
        Thread.sleep(this.aclSyncDelay);
    }

    public int order() {
        return Integer.MIN_VALUE;
    }
}

