/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin;

import io.fabric8.elasticsearch.plugin.acl.DynamicACLFilter;
import io.fabric8.elasticsearch.plugin.acl.UserProjectCache;
import io.fabric8.elasticsearch.plugin.acl.UserProjectCacheMapAdapter;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestFilter;

public class OpenShiftElasticSearchService
extends AbstractLifecycleComponent<OpenShiftElasticSearchService> {
    private final ESLogger logger;
    private final UserProjectCache cache;
    private final Settings settings;
    private ScheduledThreadPoolExecutor scheduler;
    private ScheduledFuture scheduledFuture;

    @Inject
    protected OpenShiftElasticSearchService(Settings settings, Client esClient, RestController restController) {
        super(settings);
        this.settings = settings;
        this.logger = Loggers.getLogger(((Object)((Object)this)).getClass(), (Settings)settings, (String[])new String[0]);
        this.cache = new UserProjectCacheMapAdapter(this.logger);
        restController.registerFilter((RestFilter)new DynamicACLFilter(this.cache, settings, esClient, this.logger));
    }

    protected void doStart() throws ElasticsearchException {
        this.scheduler = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"openshift_elasticsearch_service"));
        this.scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.scheduler.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        Runnable expire = new Runnable(){

            @Override
            public void run() {
                OpenShiftElasticSearchService.this.cache.expire();
            }
        };
        this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(expire, 5L, 60L, TimeUnit.SECONDS);
        this.logger.debug("Started", new Object[0]);
    }

    protected void doStop() throws ElasticsearchException {
        FutureUtils.cancel((Future)this.scheduledFuture);
        this.scheduler.shutdown();
        this.logger.debug("Stopped", new Object[0]);
    }

    protected void doClose() throws ElasticsearchException {
        FutureUtils.cancel((Future)this.scheduledFuture);
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        this.logger.debug("Closed", new Object[0]);
    }
}

