/*
 * Decompiled with CFR 0.152.
 */
package com.sonian.elasticsearch.zookeeper.discovery;

import com.sonian.elasticsearch.zookeeper.client.AbstractNodeListener;
import com.sonian.elasticsearch.zookeeper.client.ZooKeeperClient;
import com.sonian.elasticsearch.zookeeper.client.ZooKeeperClientSessionExpiredException;
import com.sonian.elasticsearch.zookeeper.client.ZooKeeperEnvironment;
import com.sonian.elasticsearch.zookeeper.discovery.ZooKeeperClusterState;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoverySettings;
import org.elasticsearch.discovery.InitialStateDiscoveryListener;
import org.elasticsearch.discovery.zen.DiscoveryNodesProvider;
import org.elasticsearch.discovery.zen.publish.PublishClusterStateAction;
import org.elasticsearch.node.service.NodeService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class ZooKeeperDiscovery
extends AbstractLifecycleComponent<Discovery>
implements Discovery,
DiscoveryNodesProvider {
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final ClusterName clusterName;
    private final ThreadPool threadPool;
    private final AtomicBoolean initialStateSent = new AtomicBoolean();
    private final CopyOnWriteArrayList<InitialStateDiscoveryListener> initialStateListeners = new CopyOnWriteArrayList();
    private final ZooKeeperClient zooKeeperClient;
    private DiscoveryNode localNode;
    private String localNodePath;
    private final StatePublisher statePublisher;
    private volatile boolean master = false;
    private volatile DiscoveryNodes latestDiscoNodes;
    private volatile Thread currentJoinThread;
    private final Lock updateNodeListLock = new ReentrantLock();
    private final MasterNodeListChangedListener masterNodeListChangedListener = new MasterNodeListChangedListener();
    private final SessionStateListener sessionResetListener = new SessionStateListener();
    private final DiscoveryNodeService discoveryNodeService;
    private final ZooKeeperEnvironment environment;
    private final AtomicBoolean connected = new AtomicBoolean();
    @Nullable
    private NodeService nodeService;

    @Inject
    public ZooKeeperDiscovery(Settings settings, ZooKeeperEnvironment environment, ClusterName clusterName, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, DiscoveryNodeService discoveryNodeService, DiscoverySettings discoverySettings, ZooKeeperClient zooKeeperClient) {
        super(settings);
        this.clusterName = clusterName;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.discoveryNodeService = discoveryNodeService;
        this.zooKeeperClient = zooKeeperClient;
        this.threadPool = threadPool;
        this.environment = environment;
        this.statePublisher = this.componentSettings.getAsBoolean("state_publishing.enabled", Boolean.valueOf(false)) != false ? new ZooKeeperStatePublisher(settings, environment, zooKeeperClient, this) : new ZenStatePublisher(settings, transportService, this, new NewClusterStateListener(), discoverySettings);
    }

    protected void doStart() throws ElasticsearchException {
        String nodeId = Strings.randomBase64UUID();
        this.localNode = new DiscoveryNode(this.settings.get("name"), nodeId, this.transportService.boundAddress().publishAddress(), this.discoveryNodeService.buildAttributes(), Version.CURRENT);
        this.localNodePath = this.nodePath(this.localNode.id());
        this.latestDiscoNodes = new DiscoveryNodes.Builder().put(this.localNode).localNodeId(this.localNode.id()).build();
        this.initialStateSent.set(false);
        this.zooKeeperClient.addSessionStateListener(this.sessionResetListener);
        this.zooKeeperClient.start();
        this.createRootNodes();
        this.statePublisher.start();
        this.asyncJoinCluster(true);
    }

    private void createRootNodes() {
        try {
            this.logger.trace("Creating root nodes in ZooKeeper", new Object[0]);
            this.zooKeeperClient.createPersistentNode(this.environment.clusterNodePath());
            this.zooKeeperClient.createPersistentNode(this.environment.nodesNodePath());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    protected void doStop() throws ElasticsearchException {
        this.statePublisher.stop();
        this.zooKeeperClient.removeSessionStateListener(this.sessionResetListener);
        this.logger.trace("Stopping zooKeeper client", new Object[0]);
        this.zooKeeperClient.stop();
        this.logger.trace("Stopped zooKeeper client", new Object[0]);
        this.master = false;
        if (this.currentJoinThread != null) {
            try {
                this.currentJoinThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void doClose() throws ElasticsearchException {
        this.zooKeeperClient.close();
    }

    public DiscoveryNode localNode() {
        return this.localNode;
    }

    public void addListener(InitialStateDiscoveryListener listener) {
        this.initialStateListeners.add(listener);
    }

    public void removeListener(InitialStateDiscoveryListener listener) {
        this.initialStateListeners.remove(listener);
    }

    public String nodeDescription() {
        return this.clusterName.value() + "/" + this.localNode.id();
    }

    public void setNodeService(@Nullable NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setAllocationService(AllocationService allocationService) {
    }

    public void publish(ClusterState clusterState, Discovery.AckListener ackListener) {
        if (!this.master) {
            this.logger.warn("Shouldn't publish state when not master", new Object[0]);
        }
        if (!this.lifecycle.started()) {
            return;
        }
        try {
            byte[] masterNode = this.zooKeeperClient.getNode(this.environment.masterNodePath(), null);
            if (masterNode == null || !new String(masterNode).equals(this.localNode.id())) {
                this.logger.warn("No longer a master, shouldn't publish new state", new Object[0]);
                return;
            }
            this.latestDiscoNodes = clusterState.nodes();
            this.statePublisher.publish(clusterState, ackListener);
        }
        catch (ZooKeeperClientSessionExpiredException ex) {
        }
        catch (Exception ex) {
            this.logger.error("Cannot publish state", (Throwable)ex, new Object[0]);
        }
    }

    public DiscoveryNodes nodes() {
        DiscoveryNodes latestNodes = this.latestDiscoNodes;
        if (latestNodes != null) {
            return latestNodes;
        }
        return DiscoveryNodes.builder().put(this.localNode).localNodeId(this.localNode.id()).build();
    }

    public NodeService nodeService() {
        return this.nodeService;
    }

    public boolean verifyConnection(TimeValue timeout) throws InterruptedException {
        if (this.connected.get()) {
            return this.zooKeeperClient.verifyConnection(timeout);
        }
        return false;
    }

    private void asyncJoinCluster(final boolean initial) {
        this.threadPool.executor("generic").execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ZooKeeperDiscovery.this.currentJoinThread = Thread.currentThread();
                try {
                    ZooKeeperDiscovery.this.innerJoinCluster(initial);
                }
                finally {
                    ZooKeeperDiscovery.this.currentJoinThread = null;
                }
            }
        });
    }

    private void innerJoinCluster(boolean initial) {
        try {
            if (!initial || this.register()) {
                if (this.localNode.isMasterNode()) {
                    this.electMaster();
                } else {
                    this.findMaster(initial);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean register() {
        if (this.lifecycle.stoppedOrClosed()) {
            return false;
        }
        try {
            this.logger.trace("Registering in ZooKeeper", new Object[0]);
            BytesStreamOutput streamOutput = new BytesStreamOutput();
            this.localNode.writeTo((StreamOutput)streamOutput);
            byte[] buf = streamOutput.bytes().copyBytesArray().toBytes();
            this.zooKeeperClient.setOrCreateTransientNode(this.localNodePath, buf);
            return true;
        }
        catch (Exception ex) {
            this.restartDiscovery();
            return false;
        }
    }

    private void findMaster(final boolean initial) throws InterruptedException {
        if (this.lifecycle.stoppedOrClosed()) {
            return;
        }
        AbstractNodeListener nodeListener = new AbstractNodeListener(){

            @Override
            public void onNodeCreated(String id) {
                ZooKeeperDiscovery.this.handleMasterAppeared(initial);
            }

            @Override
            public void onNodeDeleted(String id) {
                ZooKeeperDiscovery.this.handleMasterGone();
            }
        };
        byte[] masterId = this.zooKeeperClient.getNode(this.environment.masterNodePath(), nodeListener);
        if (masterId == null) {
            if (!initial) {
                this.removeMaster();
            }
        } else {
            this.addMaster(new String(masterId));
        }
    }

    private void electMaster() throws InterruptedException {
        if (this.lifecycle.stoppedOrClosed()) {
            return;
        }
        this.logger.trace("Electing master", new Object[0]);
        AbstractNodeListener nodeListener = new AbstractNodeListener(){

            @Override
            public void onNodeDeleted(String id) {
                ZooKeeperDiscovery.this.handleMasterGone();
            }
        };
        byte[] masterId = this.localNode().id().getBytes();
        if (this.lifecycle.stoppedOrClosed()) {
            return;
        }
        try {
            byte[] electedMasterId = this.zooKeeperClient.getOrCreateTransientNode(this.environment.masterNodePath(), masterId, nodeListener);
            String electedMasterIdStr = new String(electedMasterId);
            if (this.localNode.id().equals(electedMasterIdStr)) {
                this.becomeMaster();
            } else {
                this.addMaster(electedMasterIdStr);
            }
        }
        catch (Exception ex) {
            this.logger.error("Couldn't elect master. Restarting discovery.", (Throwable)ex, new Object[0]);
            this.restartDiscovery();
        }
    }

    private void addMaster(String masterNodeId) throws InterruptedException {
        this.logger.trace("Found master: {}", new Object[]{masterNodeId});
        this.master = false;
        this.statePublisher.addMaster(masterNodeId);
    }

    private void removeMaster() {
        this.clusterService.submitStateUpdateTask("zoo-keeper-disco-no-master (no_master_found)", (ClusterStateUpdateTask)new ProcessedClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) {
                MetaData metaData = currentState.metaData();
                RoutingTable routingTable = currentState.routingTable();
                ClusterBlocks clusterBlocks = ClusterBlocks.builder().blocks(currentState.blocks()).addGlobalBlock(Discovery.NO_MASTER_BLOCK).build();
                if (currentState.nodes().localNode() != null && currentState.nodes().localNode().dataNode()) {
                    metaData = MetaData.builder().build();
                    routingTable = RoutingTable.builder().build();
                }
                DiscoveryNodes.Builder builder = DiscoveryNodes.builder((DiscoveryNodes)currentState.nodes());
                DiscoveryNode masterNode = currentState.nodes().masterNode();
                if (masterNode != null) {
                    builder = builder.remove(masterNode.id());
                }
                if (currentState.nodes().localNode() == null) {
                    builder.put(ZooKeeperDiscovery.this.localNode).localNodeId(ZooKeeperDiscovery.this.localNode.id());
                }
                ZooKeeperDiscovery.this.latestDiscoNodes = builder.build();
                return ClusterState.builder((ClusterState)currentState).blocks(clusterBlocks).nodes(ZooKeeperDiscovery.this.latestDiscoNodes).metaData(metaData).routingTable(routingTable).build();
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                ZooKeeperDiscovery.this.sendInitialStateEventIfNeeded();
            }

            public void onFailure(String source, Throwable t) {
                ZooKeeperDiscovery.this.logger.error("unexpected failure during [{}]", t, new Object[]{source});
            }
        });
    }

    private void becomeMaster() throws InterruptedException {
        this.logger.trace("Elected as master ({})", new Object[]{this.localNode.id()});
        this.master = true;
        this.statePublisher.becomeMaster();
        this.clusterService.submitStateUpdateTask("zoo-keeper-disco-join (elected_as_master)", (ClusterStateUpdateTask)new ProcessedClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) {
                DiscoveryNodes.Builder builder = DiscoveryNodes.builder((DiscoveryNodes)currentState.nodes());
                if (currentState.nodes().localNode() == null) {
                    builder.put(ZooKeeperDiscovery.this.localNode);
                }
                builder.localNodeId(ZooKeeperDiscovery.this.localNode.id()).masterNodeId(ZooKeeperDiscovery.this.localNode.id());
                ZooKeeperDiscovery.this.latestDiscoNodes = builder.build();
                ClusterBlocks clusterBlocks = ClusterBlocks.builder().blocks(currentState.blocks()).removeGlobalBlock(Discovery.NO_MASTER_BLOCK).build();
                return ClusterState.builder((ClusterState)currentState).nodes(ZooKeeperDiscovery.this.latestDiscoNodes).blocks(clusterBlocks).build();
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                ZooKeeperDiscovery.this.sendInitialStateEventIfNeeded();
            }

            public void onFailure(String source, Throwable t) {
                ZooKeeperDiscovery.this.logger.error("unexpected failure during [{}]", t, new Object[]{source});
            }
        });
        this.handleUpdateNodeList();
    }

    private void restartDiscovery() {
        if (!this.lifecycle.started()) {
            return;
        }
        this.logger.trace("Restarting ZK Discovery", new Object[0]);
        this.createRootNodes();
        this.master = false;
        this.asyncJoinCluster(true);
    }

    private void setSessionDisconnected() {
        this.logger.trace("Session Disconnected", new Object[0]);
        this.connected.set(false);
    }

    private void setSessionConnected() {
        this.logger.trace("Session Connected", new Object[0]);
        this.connected.set(true);
    }

    private void updateNodeList(final Set<String> nodes) {
        this.clusterService.submitStateUpdateTask("zoo-keeper-disco-update-node-list", new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) {
                try {
                    HashSet currentNodes = Sets.newHashSet((Iterator)ZooKeeperDiscovery.this.latestDiscoNodes.nodes().keysIt());
                    HashSet deleted = new HashSet(currentNodes);
                    deleted.removeAll(nodes);
                    HashSet added = new HashSet(nodes);
                    added.removeAll(currentNodes);
                    ZooKeeperDiscovery.this.logger.trace("Current nodes: [{}], new nodes: [{}], deleted: [{}], added[{}]", new Object[]{currentNodes, nodes, deleted, added});
                    if (!deleted.isEmpty() || !added.isEmpty()) {
                        DiscoveryNodes.Builder builder = DiscoveryNodes.builder((DiscoveryNodes)currentState.nodes());
                        for (String nodeId : deleted) {
                            if (currentState.nodes().nodeExists(nodeId)) {
                                builder.remove(nodeId);
                                continue;
                            }
                            ZooKeeperDiscovery.this.logger.warn("Trying to deleted a node that doesn't exist {}", new Object[]{nodeId});
                            return currentState;
                        }
                        for (String nodeId : added) {
                            DiscoveryNode node;
                            if (nodeId.equals(ZooKeeperDiscovery.this.localNode.id()) || (node = ZooKeeperDiscovery.this.nodeInfo(nodeId)) == null) continue;
                            if (currentState.nodes().nodeExists(node.id())) {
                                ZooKeeperDiscovery.this.logger.warn("received a join request for an existing node [{}]", new Object[]{node});
                                continue;
                            }
                            builder.put(node);
                        }
                        ZooKeeperDiscovery.this.latestDiscoNodes = builder.build();
                        return ClusterState.builder((ClusterState)currentState).nodes(ZooKeeperDiscovery.this.latestDiscoNodes).build();
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                return currentState;
            }

            public void onFailure(String source, Throwable t) {
                ZooKeeperDiscovery.this.logger.error("unexpected failure during [{}]", t, new Object[]{source});
            }
        });
    }

    private void sendInitialStateEventIfNeeded() {
        if (this.initialStateSent.compareAndSet(false, true)) {
            for (InitialStateDiscoveryListener listener : this.initialStateListeners) {
                listener.initialStateProcessed();
            }
        }
    }

    private void handleNewClusterStateFromMaster(final ClusterState clusterState, final PublishClusterStateAction.NewClusterStateListener.NewStateProcessed newStateProcessedHandler) {
        if (!this.lifecycle.started()) {
            return;
        }
        if (!this.master) {
            if (clusterState.nodes().localNode() != null) {
                this.clusterService.submitStateUpdateTask("zoo-keeper-disco-receive(from master [" + clusterState.nodes().masterNode() + "])", (ClusterStateUpdateTask)new ProcessedClusterStateUpdateTask(){

                    public ClusterState execute(ClusterState currentState) {
                        ZooKeeperDiscovery.this.latestDiscoNodes = clusterState.nodes();
                        return clusterState;
                    }

                    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                        ZooKeeperDiscovery.this.sendInitialStateEventIfNeeded();
                        if (newStateProcessedHandler != null) {
                            newStateProcessedHandler.onNewClusterStateProcessed();
                        }
                    }

                    public void onFailure(String source, Throwable t) {
                        if (newStateProcessedHandler != null) {
                            newStateProcessedHandler.onNewClusterStateFailed(t);
                        }
                    }
                });
            } else if (this.logger.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder("Received new state, but not part of the state:\nversion [").append(clusterState.version()).append("]\n");
                sb.append(clusterState.nodes().prettyPrint());
                sb.append(clusterState.routingTable().prettyPrint());
                sb.append(clusterState.readOnlyRoutingNodes().prettyPrint());
                this.logger.trace(sb.toString(), new Object[0]);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("Received new state, but not part of the state", new Object[0]);
            }
        } else {
            this.logger.warn("Received new state, but node is master", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUpdateNodeList() {
        if (!this.lifecycle.started()) {
            return;
        }
        if (!this.master) {
            this.logger.trace("No longer master - shouldn't monitor node changes", new Object[0]);
            return;
        }
        this.logger.trace("Updating node list", new Object[0]);
        boolean restart = false;
        this.updateNodeListLock.lock();
        try {
            Set<String> nodes = this.zooKeeperClient.listNodes(this.environment.nodesNodePath(), this.masterNodeListChangedListener);
            this.updateNodeList(nodes);
        }
        catch (ZooKeeperClientSessionExpiredException ex) {
            restart = true;
        }
        catch (Exception ex) {
            restart = true;
            this.logger.error("Couldn't update node list.", (Throwable)ex, new Object[0]);
        }
        finally {
            this.updateNodeListLock.unlock();
        }
        if (restart) {
            this.restartDiscovery();
        }
    }

    public DiscoveryNode nodeInfo(String id) throws ElasticsearchException, InterruptedException {
        try {
            byte[] buf = this.zooKeeperClient.getNode(this.nodePath(id), null);
            if (buf != null) {
                return DiscoveryNode.readNode((StreamInput)new BytesStreamInput(buf, false));
            }
            return null;
        }
        catch (IOException e) {
            throw new ElasticsearchException("Cannot get node info " + id, (Throwable)e);
        }
    }

    private String nodePath(String id) {
        return this.environment.nodesNodePath() + "/" + id;
    }

    private void handleMasterGone() {
        if (!this.lifecycle.started()) {
            return;
        }
        this.logger.info("Master is gone", new Object[0]);
        this.asyncJoinCluster(false);
    }

    private void handleMasterAppeared(boolean initial) {
        if (!this.lifecycle.started()) {
            return;
        }
        this.logger.info("New master appeared", new Object[0]);
        this.asyncJoinCluster(initial);
    }

    private class ZenStatePublisher
    implements StatePublisher {
        private final PublishClusterStateAction publishClusterState;

        public ZenStatePublisher(Settings settings, TransportService transportService, DiscoveryNodesProvider nodesProvider, NewClusterStateListener listener, DiscoverySettings discoverySettings) {
            this.publishClusterState = new PublishClusterStateAction(settings, transportService, nodesProvider, (PublishClusterStateAction.NewClusterStateListener)listener, discoverySettings);
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        @Override
        public void publish(ClusterState clusterState, Discovery.AckListener ackListener) {
            this.publishClusterState.publish(clusterState, ackListener);
        }

        @Override
        public void addMaster(String masterNodeId) throws InterruptedException {
        }

        @Override
        public void becomeMaster() throws InterruptedException {
        }
    }

    private class ZooKeeperStatePublisher
    implements StatePublisher {
        private final ZooKeeperClusterState zooKeeperClusterState;

        public ZooKeeperStatePublisher(Settings settings, ZooKeeperEnvironment environment, ZooKeeperClient zooKeeperClient, DiscoveryNodesProvider nodesProvider) {
            this.zooKeeperClusterState = new ZooKeeperClusterState(settings, environment, zooKeeperClient, nodesProvider, ZooKeeperDiscovery.this.clusterName);
        }

        @Override
        public void start() {
            this.zooKeeperClusterState.start();
        }

        @Override
        public void stop() {
            this.zooKeeperClusterState.stop();
        }

        @Override
        public void publish(ClusterState clusterState, Discovery.AckListener ackListener) {
            try {
                this.zooKeeperClusterState.publish(clusterState, ackListener);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void addMaster(String masterNodeId) throws InterruptedException {
            ClusterState state = this.zooKeeperClusterState.retrieve(new NewZooKeeperClusterStateListener());
            if (state != null && masterNodeId.equals(state.nodes().masterNodeId())) {
                ZooKeeperDiscovery.this.handleNewClusterStateFromMaster(state, null);
            }
        }

        @Override
        public void becomeMaster() throws InterruptedException {
            this.zooKeeperClusterState.syncClusterState();
        }
    }

    private static interface StatePublisher {
        public void start();

        public void stop();

        public void publish(ClusterState var1, Discovery.AckListener var2);

        public void addMaster(String var1) throws InterruptedException;

        public void becomeMaster() throws InterruptedException;
    }

    private class SessionStateListener
    implements ZooKeeperClient.SessionStateListener {
        private SessionStateListener() {
        }

        @Override
        public void sessionDisconnected() {
            ZooKeeperDiscovery.this.setSessionDisconnected();
        }

        @Override
        public void sessionConnected() {
            ZooKeeperDiscovery.this.setSessionConnected();
        }

        @Override
        public void sessionExpired() {
            ZooKeeperDiscovery.this.restartDiscovery();
        }
    }

    private class NewZooKeeperClusterStateListener
    implements ZooKeeperClusterState.NewClusterStateListener {
        private NewZooKeeperClusterStateListener() {
        }

        @Override
        public void onNewClusterState(ClusterState clusterState) {
            ZooKeeperDiscovery.this.handleNewClusterStateFromMaster(clusterState, null);
        }
    }

    private class NewClusterStateListener
    implements PublishClusterStateAction.NewClusterStateListener {
        private NewClusterStateListener() {
        }

        public void onNewClusterState(ClusterState clusterState, PublishClusterStateAction.NewClusterStateListener.NewStateProcessed newStateProcessed) {
            ZooKeeperDiscovery.this.handleNewClusterStateFromMaster(clusterState, newStateProcessed);
        }
    }

    private class MasterNodeListChangedListener
    implements ZooKeeperClient.NodeListChangedListener {
        private MasterNodeListChangedListener() {
        }

        @Override
        public void onNodeListChanged() {
            ZooKeeperDiscovery.this.handleUpdateNodeList();
        }
    }
}

