/*
 * Decompiled with CFR 0.152.
 */
package com.sonian.elasticsearch.zookeeper.discovery;

import com.sonian.elasticsearch.zookeeper.client.AbstractNodeListener;
import com.sonian.elasticsearch.zookeeper.client.ZooKeeperClient;
import com.sonian.elasticsearch.zookeeper.client.ZooKeeperClientException;
import com.sonian.elasticsearch.zookeeper.client.ZooKeeperClientSessionExpiredException;
import com.sonian.elasticsearch.zookeeper.client.ZooKeeperEnvironment;
import com.sonian.elasticsearch.zookeeper.client.ZooKeeperIncompatibleStateVersionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.zen.DiscoveryNodesProvider;

public class ZooKeeperClusterState
extends AbstractLifecycleComponent<ZooKeeperClusterState> {
    private final Lock publishingLock = new ReentrantLock();
    private final ZooKeeperClient zooKeeperClient;
    private final ZooKeeperEnvironment environment;
    private final List<ClusterStatePart<?>> parts = new ArrayList();
    private final DiscoveryNodesProvider nodesProvider;
    private final ClusterName clusterName;
    private final String clusterStateVersion;
    private volatile boolean watching;

    public ZooKeeperClusterState(Settings settings, ZooKeeperEnvironment environment, ZooKeeperClient zooKeeperClient, DiscoveryNodesProvider nodesProvider, ClusterName clusterName) {
        super(settings);
        this.clusterStateVersion = "" + Version.CURRENT.major + '.' + Version.CURRENT.minor;
        this.watching = true;
        this.zooKeeperClient = zooKeeperClient;
        this.environment = environment;
        this.nodesProvider = nodesProvider;
        this.clusterName = clusterName;
        this.initClusterStatePersistence();
    }

    public void publish(ClusterState state, Discovery.AckListener ackListener) throws ElasticsearchException, InterruptedException {
        this.publish(state);
        ackListener.onTimeout();
    }

    private void publish(ClusterState state) throws ElasticsearchException, InterruptedException {
        this.publishingLock.lock();
        try {
            this.logger.trace("Publishing new cluster state version [{}]", new Object[]{state.version()});
            this.zooKeeperClient.createPersistentNode(this.environment.stateNodePath());
            String statePath = this.environment.statePartsNodePath();
            BytesStreamOutput buf = new BytesStreamOutput();
            buf.writeString(this.clusterStateVersion());
            buf.writeLong(state.version());
            for (ClusterStatePart<?> part : this.parts) {
                buf.writeString(part.publishClusterStatePart(state));
            }
            this.zooKeeperClient.setOrCreatePersistentNode(statePath, buf.bytes().copyBytesArray().toBytes());
            for (ClusterStatePart<?> part : this.parts) {
                part.purge();
            }
        }
        catch (IOException e) {
            throw new ZooKeeperClientException("Cannot publish state", e);
        }
        finally {
            this.publishingLock.unlock();
        }
    }

    public ClusterState retrieve(final NewClusterStateListener newClusterStateListener) throws ElasticsearchException, InterruptedException {
        this.publishingLock.lock();
        try {
            if (!this.lifecycle.started()) {
                ClusterState clusterState = null;
                return clusterState;
            }
            this.logger.trace("Retrieving new cluster state", new Object[0]);
            this.watching = newClusterStateListener != null;
            String statePath = this.environment.statePartsNodePath();
            AbstractNodeListener nodeListener = newClusterStateListener != null ? new AbstractNodeListener(){

                @Override
                public void onNodeCreated(String id) {
                    if (ZooKeeperClusterState.this.watching) {
                        ZooKeeperClusterState.this.updateClusterState(newClusterStateListener);
                    }
                }

                @Override
                public void onNodeDataChanged(String id) {
                    if (ZooKeeperClusterState.this.watching) {
                        ZooKeeperClusterState.this.updateClusterState(newClusterStateListener);
                    }
                }
            } : null;
            byte[] stateBuf = this.zooKeeperClient.getNode(statePath, nodeListener);
            if (stateBuf == null) {
                ClusterState clusterState = null;
                return clusterState;
            }
            BytesStreamInput buf = new BytesStreamInput(stateBuf, false);
            String clusterStateVersion = buf.readString();
            while (clusterStateVersion.indexOf(46) < clusterStateVersion.lastIndexOf(46)) {
                clusterStateVersion = clusterStateVersion.substring(0, clusterStateVersion.lastIndexOf(46));
            }
            if (!this.clusterStateVersion().equals(clusterStateVersion)) {
                throw new ZooKeeperIncompatibleStateVersionException("Expected: " + this.clusterStateVersion() + ", actual: " + clusterStateVersion);
            }
            ClusterState.Builder builder = ClusterState.builder((ClusterName)this.clusterName).version(buf.readLong());
            for (ClusterStatePart<?> part : this.parts) {
                builder = part.set(builder, buf.readString());
                if (builder != null) continue;
                ClusterState clusterState = null;
                return clusterState;
            }
            ClusterState clusterState = builder.build();
            return clusterState;
        }
        catch (IOException e) {
            throw new ZooKeeperClientException("Cannot retrieve state", e);
        }
        finally {
            this.publishingLock.unlock();
        }
    }

    public void syncClusterState() throws ElasticsearchException, InterruptedException {
        try {
            this.retrieve(null);
        }
        catch (ZooKeeperIncompatibleStateVersionException ex) {
            this.logger.info("Incompatible version of state found - cleaning. {}", new Object[]{ex.getMessage()});
            this.cleanClusterStateNode();
        }
    }

    private void cleanClusterStateNode() throws ElasticsearchException, InterruptedException {
        Set<String> parts = this.zooKeeperClient.listNodes(this.environment.stateNodePath(), null);
        for (String part : parts) {
            if ("parts".equals(part)) continue;
            this.zooKeeperClient.deleteNodeRecursively(this.environment.stateNodePath() + "/" + part);
        }
    }

    private void updateClusterState(NewClusterStateListener newClusterStateListener) {
        try {
            ClusterState clusterState = this.retrieve(newClusterStateListener);
            if (clusterState != null) {
                newClusterStateListener.onNewClusterState(clusterState);
            }
        }
        catch (ZooKeeperClientSessionExpiredException ex) {
        }
        catch (Exception ex) {
            this.logger.error("Error updating cluster state", (Throwable)ex, new Object[0]);
        }
    }

    protected void doStart() throws ElasticsearchException {
    }

    protected void doStop() throws ElasticsearchException {
    }

    protected void doClose() throws ElasticsearchException {
    }

    protected String clusterStateVersion() {
        return this.clusterStateVersion;
    }

    private void initClusterStatePersistence() {
        this.parts.add(new ClusterStatePart<RoutingTable>("routingTable"){

            @Override
            public void writeTo(RoutingTable statePart, StreamOutput out) throws IOException {
                RoutingTable.Builder.writeTo((RoutingTable)statePart, (StreamOutput)out);
            }

            @Override
            public RoutingTable readFrom(StreamInput in) throws IOException {
                return RoutingTable.Builder.readFrom((StreamInput)in);
            }

            @Override
            public RoutingTable get(ClusterState state) {
                return state.getRoutingTable();
            }

            @Override
            public ClusterState.Builder set(ClusterState.Builder builder, RoutingTable val) {
                return builder.routingTable(val);
            }
        });
        this.parts.add(new ClusterStatePart<DiscoveryNodes>("discoveryNodes"){

            @Override
            public void writeTo(DiscoveryNodes statePart, StreamOutput out) throws IOException {
                DiscoveryNodes.Builder.writeTo((DiscoveryNodes)statePart, (StreamOutput)out);
            }

            @Override
            public DiscoveryNodes readFrom(StreamInput in) throws IOException {
                return DiscoveryNodes.Builder.readFrom((StreamInput)in, (DiscoveryNode)ZooKeeperClusterState.this.nodesProvider.nodes().localNode());
            }

            @Override
            public DiscoveryNodes get(ClusterState state) {
                return state.getNodes();
            }

            @Override
            public ClusterState.Builder set(ClusterState.Builder builder, DiscoveryNodes val) {
                return builder.nodes(val);
            }
        });
        this.parts.add(new ClusterStatePart<MetaData>("metaData"){

            @Override
            public void writeTo(MetaData statePart, StreamOutput out) throws IOException {
                MetaData.Builder.writeTo((MetaData)statePart, (StreamOutput)out);
            }

            @Override
            public MetaData readFrom(StreamInput in) throws IOException {
                return MetaData.Builder.readFrom((StreamInput)in);
            }

            @Override
            public MetaData get(ClusterState state) {
                return state.metaData();
            }

            @Override
            public ClusterState.Builder set(ClusterState.Builder builder, MetaData val) {
                return builder.metaData(val);
            }
        });
        this.parts.add(new ClusterStatePart<ClusterBlocks>("clusterBlocks"){

            @Override
            public void writeTo(ClusterBlocks statePart, StreamOutput out) throws IOException {
                ClusterBlocks.Builder.writeClusterBlocks((ClusterBlocks)statePart, (StreamOutput)out);
            }

            @Override
            public ClusterBlocks readFrom(StreamInput in) throws IOException {
                return ClusterBlocks.Builder.readClusterBlocks((StreamInput)in);
            }

            @Override
            public ClusterBlocks get(ClusterState state) {
                return state.blocks();
            }

            @Override
            public ClusterState.Builder set(ClusterState.Builder builder, ClusterBlocks val) {
                return builder.blocks(val);
            }
        });
    }

    private abstract class ClusterStatePart<T> {
        private final String statePartName;
        private T cached;
        private String cachedPath;
        private String previousPath;

        public ClusterStatePart(String statePartName) {
            this.statePartName = statePartName;
        }

        public String publishClusterStatePart(ClusterState state) throws ElasticsearchException, InterruptedException {
            T statePart = this.get(state);
            if (statePart.equals(this.cached)) {
                return this.cachedPath;
            }
            String path = this.internalPublishClusterStatePart(statePart);
            this.cached = statePart;
            this.previousPath = this.cachedPath;
            this.cachedPath = path;
            return path;
        }

        private String internalPublishClusterStatePart(T statePart) throws ElasticsearchException, InterruptedException {
            String rootPath;
            String path = ZooKeeperClusterState.this.environment.stateNodePath() + "/" + this.statePartName + "_";
            try {
                BytesStreamOutput streamOutput = new BytesStreamOutput();
                this.writeTo(statePart, (StreamOutput)streamOutput);
                rootPath = ZooKeeperClusterState.this.zooKeeperClient.createLargeSequentialNode(path, streamOutput.bytes().copyBytesArray().toBytes());
            }
            catch (IOException e) {
                throw new ZooKeeperClientException("Cannot read " + this.statePartName + " node at " + path, e);
            }
            return rootPath;
        }

        public T getClusterStatePart(String path) throws ElasticsearchException, InterruptedException {
            if (path.equals(this.cachedPath)) {
                return this.cached;
            }
            T part = this.internalGetStatePart(path);
            if (part != null) {
                this.cached = part;
                this.cachedPath = path;
                return this.cached;
            }
            return null;
        }

        public void purge() throws ElasticsearchException, InterruptedException {
            if (this.previousPath != null) {
                try {
                    ZooKeeperClusterState.this.zooKeeperClient.deleteLargeNode(this.previousPath);
                }
                catch (ZooKeeperClientException ex) {
                    ZooKeeperClusterState.this.logger.trace("Error deleting node", new Object[0]);
                }
                this.previousPath = null;
            }
        }

        public T internalGetStatePart(String path) throws ElasticsearchException, InterruptedException {
            try {
                byte[] buf = ZooKeeperClusterState.this.zooKeeperClient.getLargeNode(path);
                if (buf != null) {
                    return this.readFrom((StreamInput)new BytesStreamInput(buf, false));
                }
                return null;
            }
            catch (IOException e) {
                throw new ZooKeeperClientException("Cannot read " + this.statePartName + " node at " + path, e);
            }
        }

        public ClusterState.Builder set(ClusterState.Builder builder, String path) throws ElasticsearchException, InterruptedException {
            T val = this.getClusterStatePart(path);
            if (val == null) {
                return null;
            }
            return this.set(builder, val);
        }

        public abstract void writeTo(T var1, StreamOutput var2) throws IOException;

        public abstract T readFrom(StreamInput var1) throws IOException;

        public abstract T get(ClusterState var1);

        public abstract ClusterState.Builder set(ClusterState.Builder var1, T var2);
    }

    public static interface NewClusterStateListener {
        public void onNewClusterState(ClusterState var1);
    }
}

