/*
 * Decompiled with CFR 0.152.
 */
package com.sonian.elasticsearch.zookeeper.client;

import com.sonian.elasticsearch.zookeeper.client.ZooKeeperClient;
import com.sonian.elasticsearch.zookeeper.client.ZooKeeperClientException;
import com.sonian.elasticsearch.zookeeper.client.ZooKeeperClientSessionExpiredException;
import com.sonian.elasticsearch.zookeeper.client.ZooKeeperEnvironment;
import com.sonian.elasticsearch.zookeeper.client.ZooKeeperFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;

public class ZooKeeperClientService
extends AbstractLifecycleComponent<ZooKeeperClient>
implements ZooKeeperClient {
    private volatile ZooKeeper zooKeeper;
    private final ZooKeeperEnvironment environment;
    private final ZooKeeperFactory zooKeeperFactory;
    private static final int MAX_NODE_SIZE = 1000000;
    private static final long CONNECTION_LOSS_RETRY_WAIT = 1000L;
    private final int maxNodeSize;
    private final Lock sessionRestartLock = new ReentrantLock();
    private final CopyOnWriteArrayList<ZooKeeperClient.SessionStateListener> sessionStateListeners = new CopyOnWriteArrayList();

    @Inject
    public ZooKeeperClientService(Settings settings, ZooKeeperEnvironment environment, ZooKeeperFactory zooKeeperFactory) {
        super(settings);
        this.environment = environment;
        this.zooKeeperFactory = zooKeeperFactory;
        this.maxNodeSize = settings.getAsInt("zookeeper.maxnodesize", Integer.valueOf(1000000));
    }

    protected void doStart() throws ElasticsearchException {
        try {
            Watcher watcher = new Watcher(){

                public void process(WatchedEvent event) {
                    switch (event.getState()) {
                        case Expired: {
                            ZooKeeperClientService.this.resetSession();
                            break;
                        }
                        case SyncConnected: {
                            ZooKeeperClientService.this.notifySessionConnected();
                            break;
                        }
                        case Disconnected: {
                            ZooKeeperClientService.this.notifySessionDisconnected();
                        }
                    }
                }
            };
            this.zooKeeper = this.zooKeeperFactory.newZooKeeper(watcher);
            this.createPersistentNode(this.environment.rootNodePath());
            this.createPersistentNode(this.environment.clustersNodePath());
        }
        catch (InterruptedException e) {
            throw new ZooKeeperClientException("Cannot start ZooKeeper client", e);
        }
    }

    protected void doStop() throws ElasticsearchException {
        if (this.zooKeeper != null) {
            try {
                this.logger.debug("Closing zooKeeper", new Object[0]);
                this.zooKeeper.close();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.zooKeeper = null;
        }
    }

    protected void doClose() throws ElasticsearchException {
    }

    @Override
    public void createPersistentNode(final String path) throws InterruptedException {
        if (!path.startsWith("/")) {
            throw new ZooKeeperClientException("Path " + path + " doesn't start with \"/\"");
        }
        try {
            this.zooKeeperCall("Cannot create leader node", new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    String[] nodes = path.split("/");
                    String currentPath = "";
                    for (int i = 1; i < nodes.length; ++i) {
                        currentPath = currentPath + "/" + nodes[i];
                        if (ZooKeeperClientService.this.zooKeeper.exists(currentPath, null) != null) continue;
                        try {
                            ZooKeeperClientService.this.zooKeeper.create(currentPath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                            ZooKeeperClientService.this.logger.trace("Created node {}", new Object[]{currentPath});
                            continue;
                        }
                        catch (KeeperException.NodeExistsException e) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            });
        }
        catch (KeeperException e) {
            throw new ZooKeeperClientException("Cannot create node at " + path, e);
        }
    }

    @Override
    public void setOrCreatePersistentNode(final String path, final byte[] data) throws InterruptedException {
        if (!this.lifecycle.started()) {
            throw new ZooKeeperClientException("setOrCreatePersistentNode is called after service was stopped");
        }
        try {
            this.zooKeeperCall("Cannot create persistent node", new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    if (ZooKeeperClientService.this.zooKeeper.exists(path, null) != null) {
                        ZooKeeperClientService.this.zooKeeper.setData(path, data, -1);
                    } else {
                        ZooKeeperClientService.this.zooKeeper.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    }
                    return null;
                }
            });
        }
        catch (KeeperException e) {
            throw new ZooKeeperClientException("Cannot persistent node", e);
        }
    }

    @Override
    public void setOrCreateTransientNode(final String path, final byte[] data) throws InterruptedException {
        if (!this.lifecycle.started()) {
            throw new ZooKeeperClientException("setOrCreateTransientNode is called after service was stopped");
        }
        try {
            try {
                this.zooKeeperCall("Creating node " + path, new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        ZooKeeperClientService.this.zooKeeper.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
                        return null;
                    }
                });
            }
            catch (KeeperException.NodeExistsException e1) {}
        }
        catch (KeeperException e) {
            throw new ZooKeeperClientException("Cannot create node " + path, e);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public byte[] getOrCreateTransientNode(final String path, final byte[] data, final ZooKeeperClient.NodeListener nodeListener) throws InterruptedException {
        if (!this.lifecycle.started()) {
            throw new ZooKeeperClientException("getOrCreateTransientNode is called after service was stopped");
        }
        while (true) {
            try {
                return this.zooKeeperCall("Getting master data", new Callable<byte[]>(){

                    @Override
                    public byte[] call() throws Exception {
                        return ZooKeeperClientService.this.zooKeeper.getData(path, ZooKeeperClientService.this.wrapNodeListener(nodeListener), null);
                    }
                });
            }
            catch (KeeperException.NoNodeException e) {
                try {
                    this.zooKeeperCall("Cannot create leader node", new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            ZooKeeperClientService.this.zooKeeper.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
                            return null;
                        }
                    });
                    return data;
                }
                catch (KeeperException.NodeExistsException e1) {
                    continue;
                }
                catch (KeeperException e1) {
                    throw new ZooKeeperClientException("Cannot create node " + path, e1);
                }
            }
            break;
        }
        catch (KeeperException e) {
            throw new ZooKeeperClientException("Cannot obtain node" + path, e);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public byte[] getNode(final String path, ZooKeeperClient.NodeListener nodeListener) throws InterruptedException {
        if (!this.lifecycle.started()) {
            throw new ZooKeeperClientException("getNode is called after service was stopped");
        }
        final Watcher watcher = this.wrapNodeListener(nodeListener);
        while (true) {
            try {
                Stat stat = this.zooKeeperCall("Checking if node exists", new Callable<Stat>(){

                    @Override
                    public Stat call() throws Exception {
                        return ZooKeeperClientService.this.zooKeeper.exists(path, watcher);
                    }
                });
                if (stat != null) {
                    return this.zooKeeperCall("Getting node data", new Callable<byte[]>(){

                        @Override
                        public byte[] call() throws Exception {
                            return ZooKeeperClientService.this.zooKeeper.getData(path, watcher, null);
                        }
                    });
                }
                return null;
            }
            catch (KeeperException.NoNodeException e) {
                continue;
            }
            break;
        }
        catch (KeeperException e) {
            throw new ZooKeeperClientException("Cannot obtain node " + path, e);
        }
    }

    @Override
    public Set<String> listNodes(final String path, final ZooKeeperClient.NodeListChangedListener nodeListChangedListener) throws InterruptedException {
        if (!this.lifecycle.started()) {
            throw new ZooKeeperClientException("listNodes is called after service was stopped");
        }
        HashSet<String> res = new HashSet<String>();
        final Watcher watcher = nodeListChangedListener != null ? new Watcher(){

            public void process(WatchedEvent event) {
                if (event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
                    nodeListChangedListener.onNodeListChanged();
                }
            }
        } : null;
        try {
            List<String> children = this.zooKeeperCall("Cannot list nodes", new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    return ZooKeeperClientService.this.zooKeeper.getChildren(path, watcher);
                }
            });
            if (children == null) {
                return null;
            }
            for (String childPath : children) {
                res.add(this.extractLastPart(childPath));
            }
            return res;
        }
        catch (KeeperException e) {
            throw new ZooKeeperClientException("Cannot list nodes", e);
        }
    }

    @Override
    public void deleteNode(final String path) throws InterruptedException {
        if (!this.lifecycle.started()) {
            throw new ZooKeeperClientException("deleteNode is called after service was stopped");
        }
        try {
            this.zooKeeperCall("Cannot delete node", new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    ZooKeeperClientService.this.zooKeeper.delete(path, -1);
                    return null;
                }
            });
        }
        catch (KeeperException e) {
            throw new ZooKeeperClientException("Cannot delete node" + path, e);
        }
    }

    @Override
    public void deleteNodeRecursively(final String path) throws InterruptedException {
        if (!this.lifecycle.started()) {
            throw new ZooKeeperClientException("deleteNode is called after service was stopped");
        }
        try {
            this.zooKeeperCall("Cannot delete node recursively", new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    this.deleteNodeRecursively(path);
                    return null;
                }

                private void deleteNodeRecursively(String path2) throws InterruptedException, KeeperException {
                    List nodes = ZooKeeperClientService.this.zooKeeper.getChildren(path2, false);
                    for (String node : nodes) {
                        this.deleteNodeRecursively(path2 + "/" + node);
                    }
                    ZooKeeperClientService.this.zooKeeper.delete(path2, -1);
                }
            });
        }
        catch (KeeperException e) {
            throw new ZooKeeperClientException("Cannot delete node" + path, e);
        }
    }

    @Override
    public String createLargeSequentialNode(final String pathPrefix, byte[] data) throws InterruptedException {
        String rootPath;
        if (!this.lifecycle.started()) {
            throw new ZooKeeperClientException("deleteNode is called after service was stopped");
        }
        try {
            final int size = data.length;
            rootPath = this.zooKeeperCall("Cannot create node at " + pathPrefix, new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ZooKeeperClientService.this.zooKeeper.create(pathPrefix, Integer.toString(size).getBytes("US-ASCII"), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
                }
            });
            int chunkNum = 0;
            for (int i = 0; i < size; i += this.maxNodeSize) {
                final String chunkPath = rootPath + "/" + chunkNum;
                final byte[] chunk = size > this.maxNodeSize ? Arrays.copyOfRange(data, i, Math.min(size, i + this.maxNodeSize)) : data;
                this.zooKeeperCall("Cannot create node at " + chunkPath, new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return ZooKeeperClientService.this.zooKeeper.create(chunkPath, chunk, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    }
                });
                ++chunkNum;
            }
        }
        catch (KeeperException e) {
            throw new ZooKeeperClientException("Cannot create node at " + pathPrefix, e);
        }
        return rootPath;
    }

    @Override
    public void deleteLargeNode(final String path) throws InterruptedException {
        if (!this.lifecycle.started()) {
            throw new ZooKeeperClientException("deleteNode is called after service was stopped");
        }
        try {
            this.zooKeeperCall("Cannot delete node at " + path, new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    List children = ZooKeeperClientService.this.zooKeeper.getChildren(path, null);
                    for (String child : children) {
                        ZooKeeperClientService.this.zooKeeper.delete(path + "/" + child, -1);
                    }
                    ZooKeeperClientService.this.zooKeeper.delete(path, -1);
                    return null;
                }
            });
        }
        catch (KeeperException e) {
            throw new ZooKeeperClientException("Cannot delete node at " + path, e);
        }
    }

    @Override
    public byte[] getLargeNode(final String path) throws InterruptedException {
        if (!this.lifecycle.started()) {
            throw new ZooKeeperClientException("getLargeNode is called after service was stopped");
        }
        try {
            byte[] sizeBuf = this.zooKeeperCall("Cannot read node at " + path, new Callable<byte[]>(){

                @Override
                public byte[] call() throws Exception {
                    return ZooKeeperClientService.this.zooKeeper.getData(path, null, null);
                }
            });
            int size = Integer.parseInt(new String(sizeBuf, "US-ASCII"));
            int chunkNum = 0;
            BytesStreamOutput buf = new BytesStreamOutput(size);
            int offset = 0;
            while (offset < size) {
                final String chunkPath = path + "/" + chunkNum;
                byte[] chunk = this.zooKeeperCall("Cannot read node", new Callable<byte[]>(){

                    @Override
                    public byte[] call() throws Exception {
                        return ZooKeeperClientService.this.zooKeeper.getData(chunkPath, null, null);
                    }
                });
                if (chunk == null || chunk.length == 0) {
                    return null;
                }
                buf.write(chunk);
                offset += chunk.length;
                ++chunkNum;
            }
            return buf.bytes().copyBytesArray().toBytes();
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (KeeperException e) {
            throw new ZooKeeperClientException("Cannot read node at " + path, e);
        }
        catch (IOException e) {
            throw new ZooKeeperClientException("Cannot read node at " + path, e);
        }
    }

    @Override
    public void addSessionStateListener(ZooKeeperClient.SessionStateListener sessionStateListener) {
        this.sessionStateListeners.add(sessionStateListener);
    }

    @Override
    public void removeSessionStateListener(ZooKeeperClient.SessionStateListener sessionStateListener) {
        this.sessionStateListeners.remove(sessionStateListener);
    }

    @Override
    public boolean verifyConnection(TimeValue timeout) throws InterruptedException {
        if (this.connected()) {
            final AtomicBoolean stats = new AtomicBoolean(false);
            final CountDownLatch latch = new CountDownLatch(1);
            this.zooKeeper.exists("/", null, new AsyncCallback.StatCallback(){

                public void processResult(int rc, String path, Object ctx, Stat stat) {
                    stats.set(stat != null);
                    latch.countDown();
                }
            }, null);
            latch.await(timeout.getMillis(), TimeUnit.MILLISECONDS);
            return stats.get();
        }
        return false;
    }

    @Override
    public boolean connected() {
        return this.zooKeeper != null && this.zooKeeper.getState() == ZooKeeper.States.CONNECTED;
    }

    @Override
    public long sessionId() {
        if (!this.lifecycle.started()) {
            throw new ZooKeeperClientException("sessionId is called after service was stopped");
        }
        return this.zooKeeper.getSessionId();
    }

    private void resetSession() {
        if (this.lifecycle.started()) {
            this.zooKeeper.sync("/", new AsyncCallback.VoidCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void processResult(int i, String s, Object o) {
                    block14: {
                        ZooKeeperClientService.this.sessionRestartLock.lock();
                        try {
                            ZooKeeperClientService.this.logger.trace("Checking if ZooKeeper session should be restarted", new Object[0]);
                            if (!ZooKeeperClientService.this.lifecycle.started()) break block14;
                            if (!ZooKeeperClientService.this.connected()) {
                                ZooKeeperClientService.this.logger.info("Restarting ZooKeeper discovery", new Object[0]);
                                try {
                                    ZooKeeperClientService.this.logger.trace("Stopping ZooKeeper", new Object[0]);
                                    ZooKeeperClientService.this.doStop();
                                }
                                catch (Exception ex) {
                                    ZooKeeperClientService.this.logger.error("Error stopping ZooKeeper", (Throwable)ex, new Object[0]);
                                }
                                while (ZooKeeperClientService.this.lifecycle.started()) {
                                    try {
                                        ZooKeeperClientService.this.logger.trace("Starting ZooKeeper", new Object[0]);
                                        ZooKeeperClientService.this.doStart();
                                        ZooKeeperClientService.this.logger.trace("Started ZooKeeper", new Object[0]);
                                        ZooKeeperClientService.this.notifySessionReset();
                                        return;
                                    }
                                    catch (ZooKeeperClientException ex) {
                                        block15: {
                                            if (ex.getCause() == null || !(ex.getCause() instanceof InterruptedException)) break block15;
                                            ZooKeeperClientService.this.logger.info("ZooKeeper startup was interrupted", (Throwable)((Object)ex), new Object[0]);
                                            Thread.currentThread().interrupt();
                                            ZooKeeperClientService.this.sessionRestartLock.unlock();
                                            return;
                                        }
                                        ZooKeeperClientService.this.logger.warn("Error starting ZooKeeper ", (Throwable)((Object)ex), new Object[0]);
                                        try {
                                            Thread.sleep(1000L);
                                        }
                                        catch (InterruptedException ex2) {
                                            ZooKeeperClientService.this.sessionRestartLock.unlock();
                                            return;
                                        }
                                    }
                                }
                                break block14;
                            }
                            ZooKeeperClientService.this.logger.trace("ZooKeeper is already restarted. Ignoring", new Object[0]);
                            break block14;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                        }
                        finally {
                            ZooKeeperClientService.this.sessionRestartLock.unlock();
                        }
                    }
                }
            }, null);
        }
    }

    private void notifySessionReset() {
        for (ZooKeeperClient.SessionStateListener listener : this.sessionStateListeners) {
            listener.sessionExpired();
        }
    }

    private void notifySessionConnected() {
        for (ZooKeeperClient.SessionStateListener listener : this.sessionStateListeners) {
            listener.sessionConnected();
        }
    }

    private void notifySessionDisconnected() {
        for (ZooKeeperClient.SessionStateListener listener : this.sessionStateListeners) {
            listener.sessionDisconnected();
        }
    }

    private <T> T zooKeeperCall(String reason, Callable<T> callable) throws InterruptedException, KeeperException {
        boolean connectionLossReported = false;
        while (true) {
            try {
                if (this.zooKeeper == null) {
                    throw new ZooKeeperClientException("ZooKeeper is not available - reconnecting");
                }
                return callable.call();
            }
            catch (KeeperException.ConnectionLossException ex) {
                if (!connectionLossReported) {
                    this.logger.debug("Connection Loss Exception", new Object[0]);
                    connectionLossReported = true;
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (KeeperException.SessionExpiredException e) {
                this.logger.warn("Session Expired Exception", new Object[0]);
                this.resetSession();
                throw new ZooKeeperClientSessionExpiredException(reason, e);
            }
            catch (KeeperException e) {
                throw e;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                this.logger.warn("Unknown Exception", (Throwable)e, new Object[0]);
                throw new ZooKeeperClientException(reason, e);
            }
            break;
        }
    }

    private Watcher wrapNodeListener(final ZooKeeperClient.NodeListener nodeListener) {
        if (nodeListener != null) {
            return new Watcher(){

                public void process(WatchedEvent event) {
                    switch (event.getType()) {
                        case NodeCreated: {
                            nodeListener.onNodeCreated(event.getPath());
                            break;
                        }
                        case NodeDeleted: {
                            nodeListener.onNodeDeleted(event.getPath());
                            break;
                        }
                        case NodeDataChanged: {
                            nodeListener.onNodeDataChanged(event.getPath());
                        }
                    }
                }
            };
        }
        return null;
    }

    private String extractLastPart(String path) {
        int index = path.lastIndexOf(47);
        if (index >= 0) {
            return path.substring(index + 1);
        }
        return path;
    }
}

