/*
 * Decompiled with CFR 0.152.
 */
package com.sonian.elasticsearch.rest.zookeeper;

import com.sonian.elasticsearch.action.zookeeper.NodesZooKeeperStatusRequest;
import com.sonian.elasticsearch.action.zookeeper.NodesZooKeeperStatusResponse;
import com.sonian.elasticsearch.action.zookeeper.TransportNodesZooKeeperStatusAction;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;

public class RestZooKeeperStatusAction
extends BaseRestHandler {
    private final TransportNodesZooKeeperStatusAction transportNodesZooKeeperStatusAction;

    @Inject
    public RestZooKeeperStatusAction(Settings settings, Client client, RestController controller, TransportNodesZooKeeperStatusAction transportNodesZooKeeperStatusAction) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_zookeeper/status", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/_zookeeper/status/{nodeId}", (RestHandler)this);
        this.transportNodesZooKeeperStatusAction = transportNodesZooKeeperStatusAction;
    }

    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        String[] nodesIds = Strings.splitStringByCommaToArray((String)request.param("nodeId"));
        NodesZooKeeperStatusRequest zooKeeperStatusRequest = new NodesZooKeeperStatusRequest(nodesIds);
        zooKeeperStatusRequest.zooKeeperTimeout(request.paramAsTime("timeout", TimeValue.timeValueSeconds((long)10L)));
        this.transportNodesZooKeeperStatusAction.execute((ActionRequest)zooKeeperStatusRequest, (ActionListener)new RestBuilderListener<NodesZooKeeperStatusResponse>(channel){

            public RestResponse buildResponse(NodesZooKeeperStatusResponse result, XContentBuilder builder) throws Exception {
                return new BytesRestResponse(RestStatus.OK, result.toXContent(builder, null));
            }
        });
    }
}

