/*
 * Decompiled with CFR 0.152.
 */
package com.sonian.elasticsearch.plugin.zookeeper;

import com.sonian.elasticsearch.plugin.zookeeper.Version;
import com.sonian.elasticsearch.rest.zookeeper.RestZooKeeperStatusAction;
import com.sonian.elasticsearch.zookeeper.settings.ZooKeeperSettingsManager;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.AbstractPlugin;
import org.elasticsearch.rest.RestModule;

public class ZooKeeperPlugin
extends AbstractPlugin {
    private final Settings settings;

    public ZooKeeperPlugin(Settings settings) {
        this.settings = settings;
    }

    public String name() {
        return "zookeeper";
    }

    public String description() {
        return "ZooKeeper Plugin Version: " + Version.number() + " (" + Version.date() + ")";
    }

    public Settings additionalSettings() {
        if (this.settings.getAsBoolean("sonian.elasticsearch.zookeeper.settings.enabled", Boolean.valueOf(false)).booleanValue()) {
            return ZooKeeperSettingsManager.loadZooKeeperSettings(this.settings);
        }
        return super.additionalSettings();
    }

    public void onModule(RestModule restModule) {
        restModule.addRestAction(RestZooKeeperStatusAction.class);
    }
}

