/*
 * Decompiled with CFR 0.152.
 */
package com.sonian.elasticsearch.plugin.zookeeper;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import org.elasticsearch.monitor.jvm.JvmInfo;

public class Version {
    private static final String number;
    private static final String date;
    private static final boolean snapshotBuild;

    public static String number() {
        return number;
    }

    public static String date() {
        return date;
    }

    public static boolean snapshotBuild() {
        return snapshotBuild;
    }

    public static String full() {
        StringBuilder sb = new StringBuilder("elasticsearch-zookeeper/");
        sb.append(number);
        if (snapshotBuild) {
            sb.append("/").append(date);
        }
        return sb.toString();
    }

    public static String description() {
        return "Elasticsearch ZooKeeper Plugin Version: " + number + " (" + Version.date() + ")";
    }

    public static void main(String[] args) {
        System.out.println("Elasticsearch ZooKeeper Plugin Version: " + number + " (" + Version.date() + "), JVM: " + JvmInfo.jvmInfo().vmVersion());
    }

    static {
        Properties props = new Properties();
        try {
            InputStream stream = Version.class.getClassLoader().getResourceAsStream("com/sonian/elasticsearch/plugin/zookeeper/version.properties");
            props.load(stream);
            stream.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        number = props.getProperty("number", "0.0.0");
        snapshotBuild = number.contains("-SNAPSHOT");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        date = props.getProperty("date", sdf.format(new Date()));
    }
}

