/*
 * Decompiled with CFR 0.152.
 */
package com.sonian.elasticsearch.zookeeper.settings;

import com.sonian.elasticsearch.zookeeper.client.ZooKeeperClientService;
import com.sonian.elasticsearch.zookeeper.client.ZooKeeperEnvironment;
import com.sonian.elasticsearch.zookeeper.client.ZooKeeperFactory;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.Classes;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.logging.log4j.LogConfigurator;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.settings.loader.SettingsLoaderFactory;
import org.elasticsearch.node.internal.InternalSettingsPreparer;

public final class ZooKeeperSettingsManager
extends AbstractLifecycleComponent<ZooKeeperSettingsManager> {
    private final ZooKeeperFactory factory;
    private final ZooKeeperEnvironment environment;
    private final ZooKeeperClientService zooKeeperClientService;

    private ZooKeeperSettingsManager(Settings settings) {
        this(settings, ClusterName.clusterNameFromSettings((Settings)settings));
    }

    protected void doStart() throws ElasticsearchException {
        this.zooKeeperClientService.start();
    }

    protected void doStop() throws ElasticsearchException {
        this.zooKeeperClientService.stop();
    }

    protected void doClose() throws ElasticsearchException {
        this.zooKeeperClientService.close();
    }

    private ZooKeeperSettingsManager(Settings settings, ClusterName clusterName) {
        super(settings);
        this.environment = new ZooKeeperEnvironment(settings, clusterName);
        this.factory = new ZooKeeperFactory(settings);
        this.zooKeeperClientService = new ZooKeeperClientService(settings, this.environment, this.factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Settings loadZooKeeperSettings(Settings settings) {
        try (ZooKeeperSettingsManager settingsManager = new ZooKeeperSettingsManager(settings);){
            settingsManager.start();
            Settings settings2 = ImmutableSettings.settingsBuilder().put(settingsManager.loadGlobalSettings()).put(settingsManager.loadClusterSettings()).build();
            return settings2;
        }
        return ImmutableSettings.Builder.EMPTY_SETTINGS;
    }

    private Map<String, String> loadGlobalSettings() throws InterruptedException {
        return this.loadSettings(this.environment.globalSettingsNodePath());
    }

    private Map<String, String> loadClusterSettings() throws InterruptedException {
        return this.loadSettings(this.environment.clusterSettingsNodePath());
    }

    private Map<String, String> loadSettings(String path) throws InterruptedException {
        byte[] settingsBytes = this.zooKeeperClientService.getNode(path, null);
        if (settingsBytes != null) {
            SettingsLoader loader = SettingsLoaderFactory.loaderFromSource((String)new String(settingsBytes));
            try {
                return loader.load(settingsBytes);
            }
            catch (IOException ex) {
                throw new ElasticsearchException("Cannot load settings ", (Throwable)ex);
            }
        }
        return Collections.emptyMap();
    }

    private void storeGlobalSettingsBytes(byte[] settingsBytes) throws InterruptedException {
        this.zooKeeperClientService.createPersistentNode(this.environment.clusterNodePath());
        this.zooKeeperClientService.setOrCreatePersistentNode(this.environment.globalSettingsNodePath(), settingsBytes);
    }

    private void storeClusterSettingsBytes(byte[] settingsBytes) throws InterruptedException {
        this.zooKeeperClientService.createPersistentNode(this.environment.clusterNodePath());
        this.zooKeeperClientService.setOrCreatePersistentNode(this.environment.clusterSettingsNodePath(), settingsBytes);
    }

    private byte[] loadGlobalSettingsBytes() throws InterruptedException {
        return this.zooKeeperClientService.getNode(this.environment.globalSettingsNodePath(), null);
    }

    private byte[] loadClusterSettingsBytes() throws InterruptedException {
        return this.zooKeeperClientService.getNode(this.environment.clusterSettingsNodePath(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] loadSettings(Settings settings, boolean global) {
        try (ZooKeeperSettingsManager settingsManager = new ZooKeeperSettingsManager(settings);){
            settingsManager.start();
            if (global) {
                byte[] byArray = settingsManager.loadGlobalSettingsBytes();
                return byArray;
            }
            byte[] byArray = settingsManager.loadClusterSettingsBytes();
            return byArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeSettings(Settings settings, byte[] settingsBytes, boolean global) {
        try (ZooKeeperSettingsManager settingsManager = new ZooKeeperSettingsManager(settings);){
            settingsManager.start();
            if (global) {
                settingsManager.storeGlobalSettingsBytes(settingsBytes);
            } else {
                settingsManager.storeClusterSettingsBytes(settingsBytes);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage:");
            System.out.println("    set <settings file>");
            System.out.println("    set-global <settings file>");
            System.out.println("    get");
            System.out.println("    get-global");
            return;
        }
        Tuple initialSettings = InternalSettingsPreparer.prepareSettings((Settings)ImmutableSettings.Builder.EMPTY_SETTINGS, (boolean)true);
        Settings settings = (Settings)InternalSettingsPreparer.prepareSettings((Settings)((Settings)initialSettings.v1()), (boolean)true).v1();
        ZooKeeperSettingsManager.setupLogging(settings);
        Loggers.disableConsoleLogging();
        if (args[0].equals("set") || args[0].equals("set-global")) {
            if (args.length < 2) {
                System.out.println("Properties file has to be specified");
            } else {
                byte[] settingsBytes = ZooKeeperSettingsManager.loadSettingsFile(args[1]);
                ZooKeeperSettingsManager.storeSettings(settings, settingsBytes, args[0].equals("set-global"));
            }
        } else if (args[0].equals("get") || args[0].equals("get-global")) {
            byte[] loadedSettings = ZooKeeperSettingsManager.loadSettings(settings, args[0].equals("get-global"));
            if (loadedSettings != null) {
                try {
                    System.out.write(loadedSettings);
                }
                catch (IOException ex) {}
            }
        } else {
            System.out.println("Unknown command " + args[0]);
        }
    }

    private static void setupLogging(Settings settings) {
        try {
            Classes.getDefaultClassLoader().loadClass("org.apache.log4j.Logger");
            LogConfigurator.configure((Settings)settings);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Exception e) {
            System.err.println("Failed to configure logging...");
            e.printStackTrace();
        }
    }

    private static byte[] loadSettingsFile(String path) {
        File file = new File(path);
        try {
            return Streams.copyToByteArray((File)file);
        }
        catch (IOException ex) {
            throw new ElasticsearchException("Cannot load settings file " + path, (Throwable)ex);
        }
    }
}

