/*
 * Decompiled with CFR 0.152.
 */
package com.sonian.elasticsearch.zookeeper.client;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;

public class ZooKeeperFactory
extends AbstractComponent {
    private final String host;
    private final String username;
    private final String password;
    private final TimeValue sessionTimeout;

    @Inject
    public ZooKeeperFactory(Settings settings) {
        super(settings);
        this.host = this.componentSettings.get("host");
        if (this.host == null) {
            throw new ElasticsearchException("Empty ZooKeeper host name");
        }
        this.username = this.componentSettings.get("username");
        this.password = this.componentSettings.get("password");
        this.sessionTimeout = this.componentSettings.getAsTime("session.timeout", new TimeValue(1L, TimeUnit.MINUTES));
    }

    public ZooKeeper newZooKeeper() {
        return this.newZooKeeper(new Watcher(){

            public void process(WatchedEvent event) {
            }
        });
    }

    public ZooKeeper newZooKeeper(Watcher watcher) {
        try {
            ZooKeeper zookeeper = new ZooKeeper(this.host, (int)this.sessionTimeout.millis(), watcher);
            if (this.username != null && this.password != null) {
                zookeeper.addAuthInfo("digest", String.format("%s:%s", this.username, this.password).getBytes());
            }
            return zookeeper;
        }
        catch (IOException e) {
            throw new ElasticsearchException("Cannot start ZooKeeper", (Throwable)e);
        }
    }
}

