/*
 * Decompiled with CFR 0.152.
 */
package com.sonian.elasticsearch.zookeeper.client;

import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class ZooKeeperEnvironment {
    private final String rootNodePath;
    private final String clustersNodePath;
    private final String clusterNodePath;
    private final String nodesNodePath;
    private final String stateNodePath;
    private final String globalSettingsNodePath;
    private final String clusterSettingsNodePath;
    private final String masterNodePath;
    private final String statePartsNodePath;

    @Inject
    public ZooKeeperEnvironment(Settings settings, ClusterName clusterName) {
        this.rootNodePath = settings.get("zookeeper.root", "/es");
        this.clustersNodePath = this.rootNodePath + "/" + "clusters";
        this.clusterNodePath = this.clustersNodePath + "/" + settings.get("zookeeper.cluster", clusterName.value());
        this.nodesNodePath = this.clusterNodePath + "/" + "nodes";
        this.stateNodePath = this.clusterNodePath + "/" + "state";
        this.statePartsNodePath = this.stateNodePath + "/" + "parts";
        this.globalSettingsNodePath = this.rootNodePath + "/" + "settings";
        this.clusterSettingsNodePath = this.clusterNodePath + "/" + "settings";
        this.masterNodePath = this.clusterNodePath + "/" + "leader";
    }

    public String rootNodePath() {
        return this.rootNodePath;
    }

    public String clustersNodePath() {
        return this.clustersNodePath;
    }

    public String clusterNodePath() {
        return this.clusterNodePath;
    }

    public String nodesNodePath() {
        return this.nodesNodePath;
    }

    public String masterNodePath() {
        return this.masterNodePath;
    }

    public String stateNodePath() {
        return this.stateNodePath;
    }

    public String statePartsNodePath() {
        return this.statePartsNodePath;
    }

    public String clusterSettingsNodePath() {
        return this.clusterSettingsNodePath;
    }

    public String globalSettingsNodePath() {
        return this.globalSettingsNodePath;
    }
}

