/*
 * Decompiled with CFR 0.152.
 */
package com.sonian.elasticsearch.action.zookeeper;

import com.sonian.elasticsearch.action.zookeeper.NodesZooKeeperStatusRequest;
import com.sonian.elasticsearch.action.zookeeper.NodesZooKeeperStatusResponse;
import com.sonian.elasticsearch.zookeeper.discovery.ZooKeeperDiscovery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.support.nodes.NodeOperationRequest;
import org.elasticsearch.action.support.nodes.NodesOperationRequest;
import org.elasticsearch.action.support.nodes.TransportNodesOperationAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportNodesZooKeeperStatusAction
extends TransportNodesOperationAction<NodesZooKeeperStatusRequest, NodesZooKeeperStatusResponse, NodeZooKeeperStatusRequest, NodesZooKeeperStatusResponse.NodeZooKeeperStatusResponse> {
    private final ZooKeeperDiscovery zooKeeperDiscovery;
    private static final String ACTION_NAME = "/zookeeper/settings/get";

    @Inject
    public TransportNodesZooKeeperStatusAction(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, Discovery discovery) {
        super(settings, ACTION_NAME, clusterName, threadPool, clusterService, transportService);
        this.zooKeeperDiscovery = discovery instanceof ZooKeeperDiscovery ? (ZooKeeperDiscovery)discovery : null;
    }

    protected String executor() {
        return "generic";
    }

    protected NodesZooKeeperStatusRequest newRequest() {
        return new NodesZooKeeperStatusRequest();
    }

    protected NodesZooKeeperStatusResponse newResponse(NodesZooKeeperStatusRequest nodesZooKeeperStatusRequest, AtomicReferenceArray responses) {
        ArrayList nodeZooKeeperStatusResponses = Lists.newArrayList();
        for (int i = 0; i < responses.length(); ++i) {
            Object resp = responses.get(i);
            if (!(resp instanceof NodesZooKeeperStatusResponse.NodeZooKeeperStatusResponse)) continue;
            nodeZooKeeperStatusResponses.add((NodesZooKeeperStatusResponse.NodeZooKeeperStatusResponse)((Object)resp));
        }
        return new NodesZooKeeperStatusResponse(this.clusterName, nodeZooKeeperStatusResponses.toArray(new NodesZooKeeperStatusResponse.NodeZooKeeperStatusResponse[nodeZooKeeperStatusResponses.size()]));
    }

    protected NodeZooKeeperStatusRequest newNodeRequest() {
        return new NodeZooKeeperStatusRequest();
    }

    protected NodeZooKeeperStatusRequest newNodeRequest(String nodeId, NodesZooKeeperStatusRequest nodesZooKeeperStatusRequest) {
        return new NodeZooKeeperStatusRequest(nodesZooKeeperStatusRequest, nodeId);
    }

    protected NodesZooKeeperStatusResponse.NodeZooKeeperStatusResponse newNodeResponse() {
        return new NodesZooKeeperStatusResponse.NodeZooKeeperStatusResponse();
    }

    protected NodesZooKeeperStatusResponse.NodeZooKeeperStatusResponse nodeOperation(NodeZooKeeperStatusRequest nodeZooKeeperStatusRequest) throws ElasticsearchException {
        if (this.zooKeeperDiscovery != null) {
            try {
                return new NodesZooKeeperStatusResponse.NodeZooKeeperStatusResponse(this.clusterService.state().nodes().localNode(), true, this.zooKeeperDiscovery.verifyConnection(nodeZooKeeperStatusRequest.timeout()));
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        return new NodesZooKeeperStatusResponse.NodeZooKeeperStatusResponse(this.clusterService.state().nodes().localNode(), false, false);
    }

    protected boolean accumulateExceptions() {
        return false;
    }

    public static class NodeZooKeeperStatusRequest
    extends NodeOperationRequest {
        private TimeValue zooKeeperTimeout;

        private NodeZooKeeperStatusRequest() {
        }

        private NodeZooKeeperStatusRequest(NodesZooKeeperStatusRequest request, String nodeId) {
            super((NodesOperationRequest)request, nodeId);
            this.zooKeeperTimeout = request.zooKeeperTimeout();
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.zooKeeperTimeout = TimeValue.readTimeValue((StreamInput)in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.zooKeeperTimeout.writeTo(out);
        }

        public TimeValue timeout() {
            return this.zooKeeperTimeout;
        }
    }
}

